#! /usr/bin/python

''' set up a directory for making a UHADCP adcp web page

    Usage: websetup.py webdir [programdir]

    webdir will be created and filled with
    - webglobs.m (must edit)
    - setparms (must edit)
    - README (describes what to do)

'''

import sys, os,  string,  shutil


if len(sys.argv) < 2:
   print __doc__
   sys.exit()



webdir = sys.argv[1]
if len(sys.argv) == 3:
   progdir = sys.argv[2]
else:
   progdir = '/home/noio/programs'

if not os.path.exists(progdir):
   print '"programs" root directory %s does not exist' % (progdir)
   print __doc__
   sys.exit()

srcdir = os.path.join(progdir,'matlab','web_adcp')
if not os.path.exists(srcdir):
   print '"web_adcp" directory does not exist.  expecting it to be at'
   print srcdir
   sys.exit()


if not os.path.exists(webdir):
   print ''
   print 'destination web directory %s does not exist.  making directory' % \
         (webdir)
   os.mkdir(webdir)
os.chdir(webdir)


## copy the files
print 'copying README:       read it'
shutil.copy(os.path.join(srcdir, 'README'), 'README')

print 'copying websetup.m:   must be edited'
shutil.copy(os.path.join(srcdir, 'websetup.m__'), 'websetup.m')




