#!/usr/bin/python
##to be imported by quick_adcp.py
#
# This python program should bear the name of the function contained within

import os, sys
from call_matlab import MatlabEngine

#from call_matlab import matlab

def get_posmvdh(opts):
   #This routine produces an *.ang file of they same type as produced by ashrot
   # should have already changed dir to cal/rotate

   # (1) list heading for scan_time_range so we can get a set of
   #     ensemble endday -- output is scn.hdg


   cntfile = 'lst_hdg.tmp'

   lsthdg_cnt = '''
   dbname:         ../../adcpdb/%(dbname)s
   output:           scn.hdg
   step_size=        1
   year_base=        %(yearbase)d
   time_ranges:
        %(thisload_time_range)s
   ''' %opts
   
   print lsthdg_cnt
   lhdg = open(cntfile, 'w')
   lhdg.write(lsthdg_cnt)
   lhdg.close()
   
   syscmd = '%s %s' %  (os.path.join(opts['bindir'], 'lst_hdg'), cntfile)
   try:
      os.system(syscmd)
   except:
      print 'cannot list heading in ' + os.path.getcwd()
      sys.exit()
      
   # (2) set up and run maglab mk_gyrodh
   
   matstr = '''

   cfg =get_uhdascfg('cfgbase', '%(cruisename)s', 'cfgpath', '%(cfgpath)s');


   cfg.toofarsecs = 30;
   timerange =   [%(thisload_startdd)s %(thisload_enddd)s];

   inst_info = {'gyro','hdg'};
   gyrolist = guess_rfilelist(cfg, timerange, inst_info, 'rbin');
   gyro_trinfo = tr2ilist(gyrolist);
   [gdata, gstruct] = tr2ilist(gyro_trinfo);
   
   inst_info = {'posmv','pmv'};
   otherlist = guess_rfilelist(cfg,timerange, inst_info, 'rbin');
   other_trinfo = tr2ilist(otherlist);
   [pdata, pstruct] = tr2ilist(other_trinfo);

   
   p_tdh = mk_avgdh(gdata, gstruct, pdata, pstruct, 'posmv', 'logfile', '%(logfile)s');
   
   
   pbadi = find(p_tdh.numgood < 100);
   
   pgoodi = find(find(p_tdh.numgood > 80));
   angshift = 0;
   
   
   clf
   plot(p_tdh.dday, p_tdh.ang + angshift, 'k')
   
   dday_dh = load('scn.hdg');
   dday = dday_dh (:,1);
   dh = table1([p_tdh.dday(pgoodi)', p_tdh.ang(pgoodi)'], dday);
   dh = fillends(dh);
   ddaydh = [dday dh];
   
   printit('gyrodh')
   close

   
   fid = fopen('%(time_angle_file)s','w');  
   fprintf(fid,  '%%10.8f      %%5.3f\\n', ddaydh');
   fclose(fid);

   
   
''' %opts
   
   mat = open('gyrodh_tmp.m', 'w')
   mat.write(matstr)
   mat.close()

   opts['M'].matlab(matstr, opts['matpathlist'], verbose=1)


###############################################################################3

   
def get_seapath11dh(opts):
   #This routine produces an *.ang file of they same type as produced by ashrot
   # should have already changed dir to cal/rotate

   # (1) list heading for scan_time_range so we can get a set of
   #     ensemble endday -- output is scn.hdg


   cntfile = 'lst_hdg.tmp'

   lsthdg_cnt = '''
   dbname:         ../../adcpdb/%(dbname)s
   output:           scn.hdg
   step_size=        1
   year_base=        %(yearbase)d
   time_ranges:
        %(scn_time_range)s
   ''' %opts
   
   print lsthdg_cnt
   lhdg = open(cntfile, 'w')
   lhdg.write(lsthdg_cnt)
   lhdg.close()
   
   syscmd = '%s %s' %  (os.path.join(opts['bindir'], 'lst_hdg'), cntfile)
   try:
      os.system(syscmd)
   except:
      print 'cannot list heading in ' + os.path.getcwd()
      sys.exit()
      
   # (2) set up and run maglab mk_gyrodh
   
   matstr = '''

   cfg.toofarsecs = 30;
   timerange =   [%(scn_startdd)s %(scn_enddd)s];

   inst_info = {'gyro','hdg'};
   gyrolist = guess_rfilelist(cfg, timerange, inst_info, 'rbin');

   inst_info = {'seapath1','sea'};
   otherlist = guess_rfilelist(cfg,timerange, inst_info, 'rbin');
   
   end_dday = read_asc('scn.hdg',3,1);  %%run by get_seapath11dh.py

   mk_gyrodh(gyrolist, otherlist, 'end_dday', end_dday,...
   'timerange', timerange, 'outfile', '%(time_angle_file)s',...
   'othertype', 'seabin');

   
''' %opts
   
   mat = open('gyrodh_tmp.m', 'w')
   mat.write(matstr)
   mat.close()

   opts['M'].matlab(matstr, opts['matpathlist'], verbose=1)


