#!/usr/bin/python

#### documentation ###

# quick_adcp.py documentation:
#
# print_howto_ping():
# print_howto_LTA():                NOT YET WRITTEN!!
# print_vardoc():
# print_overview():

# print_lta_commands():
# print_enx_commands():
# print_uhdas_commands():
# print_pingdata_commands():
# print_lastfiles_commands():
# print_delblks_commands():

# print_setup_info():


def print_pingdata_commands():
   str = '''
  =======================================================================
                    == Narrowband pingdata files ======

   To process NB pingdata (assuming  300-second ensembles)
   (1) run
                 adcptree.py np0304
   (2) change directories to newpingdemo/ping and link or copy the pingdata files here
   (3) then "cd .." to get back to  the processing directory 
   (4a) Now: (for example)

   quick_adcp.py --cntfile q_py.cnt

   ###   q_py.cnt is 
   --yearbase 2003                            ### for decimal day conversion
   --dbname a0304                             ### database name, in adcpdb
   --use_refsm                                ### could use --use_smoothr
   --datatype pingdata                        ### this is the default
   --datafile_glob pingdata.???               ### DO NOT quote the wildcards
   ### end of q_py.cnt

   (4b) calibration (watertrack and bottomtrack)
   
   quick_adcp.py --cntfile  q_pyrot.cnt

   ### start q_pyrot.cnt
   --yearbase 2003                            ### for decimal day conversion
   --use_refsm                                ### could use --use_smoothr
   --rotate_angle 0.58                        ### rotation 
   --steps2rerun rotate:navsteps:calib        ### do these steps
   --auto
   
   (4c) after editing:

   quick_adcp.py --cntfile  q_pyedit.cnt

   ## q_pyedit.cnt is:
   --yearbase 2003                            ### for decimal day conversion
   --use_refsm                                ### could use --use_smoothr
   --steps2rerun apply_edit:navsteps:calib:matfiles  ### do these steps
   --auto
   ### end of q_pyedit.cnt

NOTE to Windows users: replace 'quick_adcp.py' with 'quickadcp_py' and
                       replace 'adcptree.py' with 'adcptree_py'.  These
                       are .BAT files that set enviromennt variables and
                       call the respective python versions.

  ========================================================================
'''
   print str

#-----------------------------------------------------------------------------

def print_lta_commands():

   str = '''
  ========================================================================
                 == Ocean surveyor LTA or STA files ======
                                             
   (for example, no frills)
   
   To process LTA averaged data with 300-second ensembles,
   (1) run
             adcptree.py vg0404 --instclass os --datatype lta

   (2) change directories to vg0301/ping and link or copy the LTA files here
   (3) then "cd .." to get back to  the cruise directory.
   (4a) Now:  (for example)

      quick_adcp.py --cntfile q_py.cnt

   ### q_py.cnt is
   --yearbase 2004                       # for decimal day conversion
   --dbname a0404                        # database name; in adcpdb
   --use_refsm                           # could use --use_smoothr
   --instclass os                        # instrument type
   --datatype lta                        # datafile type
   --datafile_glob *.LTA                 # filename extension
   ### end of q_py.cnt

   (4b) calibration(watertrack and bottom track)

   quick_adcp.py --cntfile  q_pyrot.cnt

   ### q_pyrot.cnt is:
   --yearbase 2004                       # for decimal day conversion
   --use_refsm                           # could use --use_smoothr
   --rotate_angle 1.3                    # phase correction
   --steps2rerun rotate:navsteps:calib   # apply rotation
   --auto                                # be speedy (don\'t ask yes or no)
   ### end of q_pyrot.cnt

   quick_adcp.py --cntfile  q_pyedit.cnt

   ## q_pyedit.cnt is:
   --yearbase 2004                            # for decimal day conversion
   --use_refsm                                # could use --use_smoothr
   --steps2rerun apply_edit:navsteps:calib:matfiles  # do these steps
   --auto                                     # be speedy
   ### end of q_pyedit.cnt

   
NOTE to Windows users: replace 'quick_adcp.py' with 'quickadcp_py' and
                       replace 'adcptree.py' with 'adcptree_py'.  These
                       are .BAT files that set enviromennt variables and
                       call the respective python versions.

  ========================================================================

'''

   print str

#-----------------------------------------------------------------------------


def print_enx_commands():

   str = '''
   ========================================================================
             == Ocean surveyor ENX files ======

   (for example, no frills)
   WARNING:  - You must know the transducer depth and the transducer angle (use
             \'read\' in matlab to find them from the LTA or STA data)
   
   To process ENX (single-ping, earth coordinates) data with 300-second
   averages,  Ocean Surveyor data, "nb" pings

   (1) run
          adcptree.py vg0404 --instclass os --pingtype nb --datatype enx

   (4) Now: 
   (4a) Now:  (for example)

      quick_adcp.py --cntfile q_py.cnt

   ### q_py.cnt is
   --yearbase 2004                       # for decimal day conversion
   --dbname a0404                        # database name; in adcpdb
   --ducer_depth 7                       # ENX needs transducer depth
   --use_refsm                           # could use --use_smoothr
   --instclass os                        # instrument type
   --datatype lta                        # datafile type
   --datafile_glob *.LTA                 # filename extension
   ### end of q_py.cnt


   (4b) calibration(watertrack and bottom track)

  quick_adcp.py --cntfile  q_pyrot.cnt


    ### q_pyrot.cnt is:
   --yearbase 2004                       # for decimal day conversion
   --use_refsm                           # could use --use_smoothr
   --rotate_angle 1.3                    # phase correction
   --steps2rerun rotate:navsteps:calib   # apply rotation
   --auto                                # be speedy (don\'t ask yes or no)
   ### end of q_pyrot.cnt

   quick_adcp.py --cntfile  q_pyedit.cnt

   ## q_pyedit.cnt is:
   --yearbase 2004                            # for decimal day conversion
   --use_refsm                                # could use --use_smoothr
   --steps2rerun apply_edit:navsteps:calib:matfiles  # do these steps
   --auto                                     # be speedy
   ### end of q_pyedit.cnt

   
NOTE to Windows users: replace 'quick_adcp.py' with 'quickadcp_py' and
                       replace 'adcptree.py' with 'adcptree_py'.  These
                       are .BAT files that set enviromennt variables and
                       call the respective python versions.

   ========================================================================

'''

   print str

#-----------------------------------------------------------------------------

def print_ens_commands():

   str = '''
   ========================================================================
             == Ocean surveyor ENS files ======

   (for example, no frills)
   WARNINGS:
     - You must have gyro heading coming directly into your deck unit
             or this won\'t work.  Advise using ENX data instead
     - You must know the transducer depth and the transducer angle (use
             \'read\' in matlab to find them from the LTA or STA data)
   
   To process ENS (single-ping, beam coordinates) data with 300-second
   averages,  Ocean Surveyor data, "nb" pings

   (1) run
            adcptree.py vg0404 --instclass os --pingtype nb --datatype ens

   (2) Now: 

   quick_adcp.py --yearbase 2004  --dbname a0404 --use_refsm \\
   --ducer_depth 7  --ens_halign 45 \\
   --datatype ens --instclass os --pingtype nb  --datafile_glob "*.ENS"
   
   and to recalibrate: (example with angle correction 1.3)
   
   quick_adcp.py --yearbase 2003 --use_refsm --rotate_angle 1.3  \\
   --steps2rerun rotate:navsteps:calib

   and after editing,

   quick_adcp.py --yearbase 2003 --use_refsm  \\
   --steps2rerun apply_edit:navsteps:calib:matfiles --auto
   

   
NOTE to Windows users: replace 'quick_adcp.py' with 'quickadcp_py' and
                       replace 'adcptree.py' with 'adcptree_py'.  These
                       are .BAT files that set enviromennt variables and
                       call the respective python versions.

   ========================================================================

'''

   print str

#-----------------------------------------------------------------------------

def print_lastfiles_commands():

   str = '''
  ========================================================================
  Description: This mode of quick_adcp.py is designed to "incrementally" process
  files as they are generated during a cruise.  (The other mode would be called
  "batch" mode, since all files are processed at the same time.)  Using the
  "lastfiles" option with these files should work fine.

  For averaged data files, (pingdata, STA, or LTA), a new block starts with the
  beginning of each file (though a file may generated more than one block).  For
  single-ping data files (uhdas, ens, enx), blocks do not always start at the
  beginning of a file.  Using the "lastfiles" option with single-ping data may be
  somewhat problematic.

  In any case, a good general rule is "Always make sure to back up enough to
  REDO the last file loaded during any previous call to quick_adcp.py"  


  ========================================================================
      == example for daily (incremental) processing of LTA files ==
                          (unix only)
      
   (for example, no frills)
   
   To process LTA averaged data (assuming 300-second ensembles)
   (1) run
               adcptree.py vg0301 --instclass os --datatype lta
                  
   (2) - identify the directory with the data (probably an smbmount; LTADIR)
       - figure out how many files are written out in a day (say 3)

   (3) Now, every 12 hours:

   quick_adcp.py --cntfile q_py.cnt


   #### begin q_py.cnt
   ## all lines after the first "#" sign are ignored
   --yearbase 2003                         # for correct decimal day conversion
   --dbname a0301                          # database is in adcpdb
   --use_refsm                             # could specify --use_smoothr
   --datatype lta                          # specify data type
   --instclass os                          # specify instrument
   --lastfiles 2                           # for incremental processing
                                           # BE SURE REDO enough files
   --datadir  LTADIR                       # data directory (example)
   --datafile_glob "*.LTA"                 # wildcard expansion in datadir
   ## end of q_py.cnt
   
   ========================================================================
'''

   print str

def print_delblks_commands():

   str = '''
  ========================================================================
  Description: This mode of quick_adcp.py is designed to "incrementally" process
  UHDAS files as they are generated during a cruise.  (The other mode would be called
  "batch" mode, since all files are processed at the same time.)
  
  For UHDAS data files,  a new block starts when a configuration is changed
  (which corresponds to the beginning of a file) or when the previous block 
  is full (which can occur in the middle of the file).  The matlab averaging
  program (write_blk.m) is incremental in nature, so its output (prefix ens_blkNNN)
  (suffixes .log, .bin, .cmd, .gps1, .gps2) files need not be rewritten.

  Use "--blkfiles 1" to indicate that the last block file from the database should
  be deleted, and because addition to the averaged data is incremental, everything
  should work.

  ========================================================================
      == example for  (incremental) processing of UHDAS files ==
                          (unix only)
      
   (for example, no frills)
   
   To process raw data (assuming 300-second ensembles)
   (1) run

   adcptree.py  km0413  -i os -n os38 -p bb -d uhdas \
   --configroot km0413 --configpath /datadir/km0413/raw/config

   (2) In a script (every N hours)

   quick_adcp.py --cntfile q_py.cnt


   #### begin q_py.cnt
   ## all lines after the first "#" sign are ignored
   --yearbase 2004                         # for correct decimal day conversion
   --dbname a0413                          # database is in adcpdb
   --use_refsm                             # could specify --use_smoothr
   --datatype uhdas                        # specify data type
   --cfgbase km0413                        # prefix for *_cfg.m, *_proc.m
                                           # cfgpath is config/
   --blkfiles 1                            # for incremental processing
   --head_func                             # in quick_user.py: gyro-posmv
   --datadir /home/data/km0413/raw/os38    # data directory (example)
   --auto
   
   ## end of q_py.cnt
   
   ========================================================================
'''

   print str


#-----------------------------------------------------------------------------


def print_uhdas_commands():   

   str = '''
   
   ==== UHDAS bb pings ================    unix only
   
   adcptree.py  km0404 /home/ulili/programs \\
   --instclass os \\
   --datatype uhdas \\
   --pingtype bb \\
   --configroot km0404 \\
   --configpath /home/data/km0404/raw/config

   \!\! ==> [check config/km0404_cfg.m and km0404_proc.m] <== \!\!

   cd \$procdir
   
   quick_adcp.py --yearbase 2004 --dbname a0404    --use_refsm  \\
   --pingtype bb             \\
   --instclass os            \\
   --datatype uhdas          \\
   --progdir $prog           \\
   --cfgbase km0404          \\
   --cruisename km0404       \\
   --instname os38           \\
   --datadir /home/data/km0404/raw/os38
   
   (and of course, reset pingtype to do nb pings; and use --ens_dday)

'''

   print str

#-----------------------------------------------------------------------------


def print_tips():
   
   str = '''

- VmDAS data configurations

  You can run the following before starting to get configuration
  information.  There are three steps, all run in matlab.  This example is
  for LTA files, but it can be run on any VmDAS files.  The os below refers
  to "ocean surveyor" (if you had a broadband, you would use bb instead).
  NO QUOTES on bb -- it is a class not a string.
  DO NOT name a variable bb, nb, or os
  
  (1) get a file list:   
             filelist =   dirs('/path_to_data/datadir/*ENS','fullfile',1);
  (2) get the configuration information into a structure:
             cc=get_configs(os,'filelist',filelist);
  (3) write it out:
             write_configs(cc);



'''

   print str

#-----------------------------------------------------------------------------


def print_overview():
   
   str = '''

Quick_adcp.py is a python script that runs all the usual CODAS processing steps,
providing a good place to start processing ADCP data.  For data sets with
no glitches (i.e. all the navigation is present, no repeated timestamps, data files
sorted in ascii order are also in time order, etc), this will allow fast,
documented, and repeatable processing for a first look at the data or if you\'re
lucky, for final processing.  This includes setting up the editing directory
so \'gautoedit\' will run.  
The entire dataset can usually be processed completely with just the following:
- adcptree.py (to set up the processing directory)
- quick_adcp.py (to do the processing, and redo steps)
- gautoedit (to do the editing)

NOTE to Windows users: replace 'quick_adcp.py' with 'quickadcp_py' and
                       replace 'adcptree.py' with 'adcptree_py'.  These
                       are .BAT files that set enviromennt variables and
                       call the respective python versions.


Quick_adcp.py uses commandline arguments to specify input information (file
names, database name, yearbase, etc).  You can skip a step by typing \'n\'
(for \'no\', do not do it) or you can stop at any stage by typing \'q\'
(for \'quit\').  A log is kept as steps are run; it is the processing directory and
has a suffix ".runlog"

   
assumes
  - adcptree.py was already run (see adcptreey.py for help)
        Be sure to specify datatype and instclass if necessary
  - quick_adcp.py is run from the adcp processing directory (PROCDIR)
       - it writes a log of steps run and values used (see
         PROCDIR/CRUISENAME.runlog)
  - data location depends on data type, as follows:
      - default is PROCDIR/ping
           pingfile note:  "linkping.py" is useful to link pingdata from
           other locations to ./ping as ascii-sortable pingdata.* (unix only)
  - data files are found by using the default directory or specified
           directory (\'datadir\') and wildcard expansion  \'datafile_glob\'
            MAKE SURE TO PUT QUOTES AROUND THE WILDCARD STRING USED
  - sets up new "gautoedit" files:
       -  makes asetup.m aflagit_setup.m  in edit/
       - (optionally) makes setup.m in edit/ with all thresholds (except
          bottom) disabled.  This is useful if you are going to use the
          old waterfall editing strictly as a tool to _manually_ flag
          bins or profiles but don\'t want it to guess what to flag.
  - makes and runs setflags.tmp with PG cutoff set
  - allows frequently-run steps to be rerun without querying (specifically,
          applying editing flags, rerunning nav steps, rerunning calibration,
          making new matlab files for plotting
          

CODAS shipboard ADCP processing steps:  (see process.txt for details)
  - scan: get the time range of the scanned data
  - load: put the data in the database, get the time range of the database
  - (set up gautoedit files, run setflags to flag bad PG at the outset)    
  - ubprint (for pingdata)         (or cat navigation if VMDAS or UHDAS)
  - ashrot  (for pingdata)
  - rotate
  - nav steps:     (choose to use either refsm or smoothr for navigation.)
           adcpsect              # these three must be run anyway for
           refabs                #   reflayer diagnostic plots and
           smoothr               #   watertracking or recip to work)
           (refsm, if specified)
  - plot reference layer (default:bins 4-12, or specified on command line)
  - putnav;              (uses whatever was specified: refsm or smoothr)
  - watertrack
  - bottom track
  - lists and plots temperature
  - timegrid (for standardized matlab files)
  - standardized matlab vector and contour files

apply calibrations to  ADCP data:
  (you have to look at the watertrack and bottom track calibration
       to see what rotation or amplitude factors might be necessary)
  (you have to go into edit/ and run gautoedit to remove the bad data)
  (then reprocessing uses "steps2rerun" to run these steps
  "rotate"     - rotate
  "navsteps"   (choose either refsm or smoothr for navigation.)
              - adcpsect           (1) # these three must be run anyway for
              - refabs             (2) #     reflayer diagnostic plots and
              - smoothr            (3) #     watertracking or recip to work)
              - refsm                  # for navigation, if specified
              - plot reference layer 
              - putnav;                # from specified (refsm, smoothr)
  "calib"     - watertrack
              - bottom track
  "matfiles"   
               - timegrid (for standardized matlab files)
               - standardized matlab vector and contour files


after editing, apply editing to database:
  "apply_edit" - applies ascii files edit/*.asc to database
  "navsteps", calib, matfiels (as above)



Notes:

 1) Run quick_adcp.py in one window, with another for investigating
    problems.  Be sure to check the output of scan before trying to load,
    in case there  are problems with timestamps.

 2) For data other than pingdata, quick_adcp.py will run matlab to create
    intermediate files that are then loaded into the database (*.cmd and *.bin).
    The navigation file is created by catting the ".gps1" files from the
    load/ subdirectory (after ldcodas has been run).  In this case the nav file
    has a .gps  suffix. Otherwise, the nav file comes from ubprint and has a ".ags"
    suffix.

 3) If processing single-ping data (ENS, ENX, or UHDAS):
    ---> DO NOT DELETE the BLKINFO.txt file or blkinfo.mat <---
    in the load/ directory.

 4) running quick_adcp.py more than once:
    a) after a single-pass load of the data, you may want to apply editing,
       run the navigation steps, apply a rotation, rerun the calibration
       steps,  or make new matlab files.  use "steps2rerun"
    b) if you are at sea and want to run quick_adcp.py once a day to
       incorporate  the new data, use --lastfiles (not well-documented yet)

 '''
   print str

#--- end print_overview --------------------------------------------------


def  print_howto_lta():

   str = '''

This will have a quick LTA example
'''
   print str

#---------------------

def  print_howto_ping():

   str = '''

(0) If you are running MSWindows, you run a .BAT files called quickadcp_py
     to set paths and get around commandline length limit.  See
     adcp_processing.html (created  by adcptree_py) for more details.

(1) Determine your processing location, create the processing directory:

         "adcptree.py vg0404"

(2) Copy (or link) the pingdata files to the ping/ subdirectory

(3) in the processing directory, run:

    quick_adcp.py --dbname a0404 --yearbase 2004 --use_refsm


    explanation:
    * "--dbname": specifying the database is actually unnecessary because it
          will locate the name from adcpdb/*dir.blk
    * "--yearbase" specified so the decimal days come out correctly
    * "--use_refsm" specifies that smoothed navigtion will come from the
          "refsm.sm" file as opposed to ademo.sm (which comes from smoothr).
          You must specify one type of navigation.  All the old nav steps get
          run anyway because we still need them for the reference layer
          diagnostic plots and for watertrack calibration.

    ### defaults are equievalent to the following control file:
    --rl_startbin 2
    --rl_endbin   20
    --datadir ping
    --datafile_glob pingdata.*   ## you could change this to PINGDATA.*
    --pgmin 50
    --rotate_angle 0.0
    --rotate_amp 1.0
    #### end of cntfile description

   it asks                            you say             why
    -------------                    -------------        ------
scan pingdata data now?                  y      scan the ping files,
                                                - create scan/a0404.scn
                                                - create scan/a0404.tr


load pingdata now?                       y      load the pingdata into
                                                  the database


make a new pre-configured setup.m ?      y      makes edit/asetup.m and
                                                  edit/aflagit_setup.m
                                                  for gautoedit editing


run setflags?                            y      sets profile flags
                                                  for pg minimum

                                                  
run ubprint?                             y       making .ags (position)
                                                   file, also extracts
                                                   ashtech heading file
                                                   (nav/a0404.mat)

run ashrot?                              y       makes ashtech (ash-gyro)
                                                   file in cal/rotate
                                                         

write ashtech statistics log file?       y       
                                                 
run rotate?                              y       apply a0404.ang, logfile:
                                                  cal/rotate/rotate.log
                                                  (amp=1.0, phase=0.0)
                                                 
run adcpsect?                            y       making .nav file
                                                  (used for watertrack
                                                  and reflayer plots)
                                                 
                                                 
run refabs?                              y       making .ref file
                                                  (used for watertrack
                                                  and reflayer plots)
                                                 
                                                 
run smoothr?                             y       make .sm file
                                                  (used for watertrack
                                                   and reflayer plots)
                                                 
                                                 
run refsm for smoothed navigation?       y       make nav/refsm.sm for
                                                   putnav
                                                 
                                                 
run putnav?                              y        put refsm.sm navigation
                                                    into database
                                                 
make reference layer plots?              y        make reference layer
                                                    plots.
                                                    
                                                 
run lst_temp?                            y        list temperature,
                                                    make plot (in edit/)
                                                 
run botmtrack and watertrack calibrations? y      Do  water track
                                                   calibration (uses 7
                                                   fixes) and bottom
                                                   track calibration
                                                   ( step size of 1)
                                                 
make matlab files for plotting?          y        runs adcpsect, makes
                                                    (50m bins, 60min)
                                                    averages in vector/
                                                    (10m bins, 15min)
                                                    averages in contour/



NOTES:
=======

... and then it\'s done.  Now go look over what has happened: a log of
steps run by quick_adcp.py is left in vg0404/vg0404.runlog.  

Check the watertrack and bottom track calibration values, adjust accordingly.
Edit the data (in edit, fire up matlab and run 'gautoedit')
Apply the editing.
(see \'quick_adcp.py --commands pingdata\' for more details)



'''
   print str

#--- end print_howto_ping--------------------------------------------------

def print_vardoc():
   str = '''
- - - - - - - - - - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - 

These are relevant to any codas processing of shipboard ADCP data


Options are specified on the command line or in a file.  9see below)

           === directories and files ===

 variable         default     # description
 -------       ----------     -----------------

cntfile            None    # override defaults with values from this
                           #   control file.  Format is the same as
                           #   command line options, but whitespace is
                           #   unimportant.  Do not quote wildcard
                           #   characters in the cnt file (whereas
                           #   you would for the command line)
                           # Defaults are overridden by this cntfile
                           # Commandline options can override either.


cruisename        (cwd)    # title name only
procdir           (cwd)    # processing direcory -- same as 
                           #     2nd argument of adcptree.py)

datadir       \'../ping\'  # data path relative to scan or load directory
progdir           \'\'     #where to find the programs (automatic detection)
binos           \'lnx\'    #subdirectory name  with executables

datafile_glob \'PINGDATA.???\'#look for sequential pingdata files


dbname           None      # limit 5 characters, start with "a"
                           #   then append  4 characters

fixfile          None      # override the default fix file.  defaults are:
                           # if datatype is pingdata, default is [dbname].ags
                           # otherwise default is [dbname].gps

nozap            0         # do not make a "setup.m" suitable for old
                           # waterfall-style editing.  default is false
                           #  (i.e. DO make a new setup.m for waterfall
                           # editing (called \'zap\' in gautoedit)

           === instrument configuration ===
 variable         default     # description
 -------       ----------     -----------------

yearbase         None      # 4 digits
                                

instname          nb       # instrument type, describes instrument 
                           #       Default is "nb"
                           #      choose from:
                           #      os    (phased array "ocean surveyor")
                           #      bb    (broadband instrument)
                           #      nb    (narrowband instrument)
                           #      son   (sontek)

pingtype          nb       #  only required for instrument "os"
                           #   using uhdas (then choose "nb" or "bb")
                           #  For all others, only one pingtype is
                           #     possible ( therefore pingtype defaults
                           #     to instrument type)

datatype       \'pingdata\'      
                           # choose what kind of data logging (and
                           #   hence which kind of data files 
                           #   are being processed)
                           #
                           # default is "pingdata"
                           #
                           #  name          what
                           #  ----          ----
                           #  "pingdata"     implies DAS2.48 (or 2.49) NB
                           #                     data, already averaged
                           #  "uhdas"        implies known directory 
                           #                     structure for access
                           #                     to raw data
                           #  "lta", "sta"   VmDAS averages
                           #  "enx"          implies VmDAS single-ping
                           #                     data,time-corrected,
                           #                     navigated with attitude



ub_type        \'1920\'      # For NB DAS only: User buffer type:
                           # 720 for demo, usually 1920 for recent cruises

ens_len         300        # seconds in an ensemble

no_head_corr      0        # default: yes, there is heading correction
                           # from a gps heading source such as Ashtech
                           # use \'--no_head_corr\' to turn that off

numbins          60        # number of bins to use with editing
                           # (60 is a good guess)

firstdepth       25        #shallowest depth bin for matlab calculations

           === processing options ===

 variable         default     # description
 -------       ----------     -----------------

                           ##  choose one or the other for smoothed nav
use_refsm        0         # use refsm for smoothed navigation
use_smoothr      0         # use smoothr for smoothed navigation

rotate_amplitude  1        # start with 1.0 for amp and 0.0 for phase
rotate_angle      0        # Applied along with gyro minus gps.
                           # (\'phase\' from watertrk or btmtrk calib)
                           # ONLY used with pingdata or LTA files

rl_startbin       2        # first bin for reference layer
rl_endbin        20        # last bin for reference layer

pgmin             0        # only accept PG greater than this value
                           # --> don\'t go below 30 <--
                           # default is 50 for datatypes \'pingdata\',
                           # \'bblta\', and \'oslta\'
                           ### (default is 20 for manually averaged ###
                           ### single ping data, nbuh and sonuh) ###

head_func     ashrot       # use this python function to get the correction.
                           # 'ashrot' is the default (only works for pingdata)
                           # BETA TESTING: 
                           # try "--head_func get_posmvdh" for posmv

rbindir     /home/adcp/cruise/rbin   ### MUST BE CORRECT for head_func to work
                           # location of rbin instrument directories,
                           #   i.e. root of gyro, adu2, posmv, etc.
                           #   default: /home/adcp/cruise/rbin


           === REPROCESSING options ===


 variable         default     # description
 -------       ----------     -----------------
                           #
                           # Once quick_adcp.py has been run, reprocessing
                           # steps can be run by specifying --steps2rerun
                           # with the following options.  Try 
                           # "quick_adcp.py --usage" for details
                           #
steps2rerun                # colon-separated list of the following:
                           # \'apply_edit:navsteps:calib:matfiles\', designed
                           # for batch mode; assumes codasdb already in
                           # place, operates on entire database.
                           #
                           # \'navsteps\' is:
                           #   [adcpsect+refabs+smoothr or refsm], putnav
                           # \'apply_edit\' is:
                           #   badbin, dbupdate, set_lgb, setflags
                           # \'calib\' is:
                           #   botmtrk (refabsbt, btcaluv)
                           #   watertrk (adcpsect, timslip, adcpcal)
                           # \'matfiles\' is:
                           #   adcpsect for vector and contour

           === specialized processing options  ===
           ===  (use: unattended underway processing via cron)    ===

                       
 variable         default     # description
 -------       ----------     -----------------

hidedisplay      0         # show figures as they are made (turn off
                           # to run from a script with cron on a ship
allow_reload     0         # allow (deletion and) reloading of data:
                           #    - used when running incrementally 
                           #    -- allow_reaload -- auto => force reload
lastfiles [integer]        # incremental processing: delete the last (few)
                           # blockfiles and (average and) load all
                           # data after the remaining database.
                           # NOTE: for LTA and pingdata, \'lastfiles\'
                           # refers to number of data files.  For UHDAS
                           # it refers to block files.
                           # (use "--commands lastfile" for more info)
                           # NOTE "--lastfiles 1" works for:
                           #      pingdata, LTA, STA, UHDAS
                           #
auto             0         # 1: whiz along (do not prompt); do all
                           #    requested steps (default is all step)
                           #    0 to prompt at each step
find_pflags      0         #  automatically find profile flags (run autoedit)
                           #  and apply editing (dbupdate, etc)
                           #  For use with automatic incremental logging and
                           #    processing of data, eg N.B.Palmer
                           #


           ===  raw processing, ENS or ENX files from VmDAS ===
 variable         default     # description
 -------       ----------     -----------------
           

ducer_depth      0         # add this to measured depth bins to correct
                           # transducer depth: ONLY used with single-ping
                           # data 

pingedit         0         # single-ping editing: edit pings before averaging


ens_halign    \'None\'       # for ENS processing only, conversion from
                           # beam to earth coordinates: need to
                           # specify transducer alignment -- REQUIRED
                           # (ENX files are already in earth coordinates)
                           # (see \'rotate_angle\' and \'rotate_file\'
                           #    for rotation of codas database
                           #    as part of calibration steps

           === raw processing, uhdas only ===

 variable         default     # description
 -------       ----------     -----------------


enddday_file               # copy this file to the load directory and use
                           # its times as ensemble end-times.  (eg. align
                           # times with a the same cruise processed
                           # with pingdata).                              

cfgbase                    #  raw logging path and config information here.
                           # files are [cfgbase]_cfg.m, [cfgbase]_proc.m,
                           # and [cfgbase]_disp.m, located in cfgpath

cfgpath                    # get raw logging path information here.
                           # For uhdas, adcptree.py makes a
                           # directory "config" and populates it with
                           # copies of existing files (cfgbase_*.m)
                           # or templates.  Edit as needed BEFORE running
                           # quick_adcp.py

 -------       ----------     -----------------
 variable         default     # description   (SEE PREVIOUS TEXT)
-----------------------------------------------------------------------------

NOTE: files can be identified in two ways:
  (1) file names after all the switches must be explicit files with path
      names correct as seen from the load/ or scan/ direcories.
      Fully qualified filenames will work
  (2) See note above about datadir and datafile_glob usage
  
usage depends on data type.  try these for help:

(unix:)                                 # Simple example for:
                                        # -------------------
quick_adcp.py --commands  LTA           #  LTA or STA files
quick_adcp.py --commands  ENX           #  ENX or ENS files
quick_adcp.py --commands  UHDAS         #  UHDAS files
quick_adcp.py --commands  pingdata      #  pingdata files
quick_adcp.py --commands  lastfiles     #  at-sea processing ("incremental")

(Windows):
NOTE to Windows users: replace 'quick_adcp.py' with 'quickadcp_py' and
                       replace 'adcptree.py' with 'adcptree_py'.  These
                       are .BAT files that set enviromennt variables and
                       call the respective python versions.


in general,...
quick_adcp.py --yearbase num --dbname axxxx \\
   [--use_refsm | --use_smoothr] \\
  --datatype [pingdata | lta | sta | ens | enx | uhdas] \\
  --pingtype [nb | bb | son] \\
  --instclass [os | nb | sbb | son] \\
  [--datadir dirname --datafile_glob "quoted_expression"] file1 [file2 ...]



'''
   print str
