##for loaduh_tmp.m

def ldcodas(opts, cntfile):

   ldcodas_cnt = '''
   DATABASE_NAME:   ../adcpdb/%(dbname)s
   DEFINITION_FILE: %(data_def)s
   LOG_FILE:  load.log
   YEAR_BASE: %(yearbase)d
   END

''' % opts

   pat = r"\b\d{2,4}/\d{2}/\d{2}\s+\d{2}:\d{2}:\d{2}\b"      

   # in case there are listed files which didn't get cmd files
   clist = glob.glob('*.cmd')
   alist = [os.path.basename(f) for f in opts['filelist']] #all
   ok_cmdlist = [alist[ii]+'.cmd' for ii in range(0,len(alist)) \
                 if (alist[ii]+'.cmd') in clist]  #all which are done

   ## loop through existing cmd files looking for new_block at file start
   blockstarti = []
   for ii in range(0,len(ok_cmdlist)):
      fid = open(ok_cmdlist[ii],'r')
      lines = fid.readlines()[0:10]  # read some lines; don't need first one
      fid.close()
      if lines[1].rstrip() == 'new_block':
         datastart_time = ''
         for iline in range(0,len(lines)):
            if lines[iline].split(':')[0] == 'new_profile':
               matchobj = re.findall(pat, lines[iline])
               if len(matchobj) > 0:
                  datastart_time = matchobj[0]
                  datastart_dd = ddtime(datastart_time, str(opts['yearbase']))
                  break
         print 'newblock for file(ii=%d): %s, starrdd = %f' % \
               (ii, ok_cmdlist[ii], datastart_dd)
         blockstarti.append(ii)
         # stop at the first instance of a new block in a cmd file
         # that starts AFTER the database.  i.e. can start ldcodas here.
         if  datastart_dd > opts['remaining_enddd']:
            print 'found a new_block "cmd" file after database ends\n'
            break

   print blockstarti
   lastblockstart = blockstarti[-1]
   #print 'BEFORE: ok_cmdlist is:\n', string.join(ok_cmdlist, '\n')
   #print 'last is %d\n' % (lastblockstart)
   ok_cmdlist = ok_cmdlist[lastblockstart:]
   #print 'AFTER: ok_cmdlist is:\n', string.join(ok_cmdlist, '\n')

   ## now find out the time range of the data being loaded:
   ## we already ahve the first time from the above block-start determintation
   opts['thisload_time_range'] = datastart_time
   opts['thisload_startdd']    = datastart_dd      
   ## look for the last value
   fid = open(ok_cmdlist[-1],'r')
   lines = fid.readlines()
   fid.close()
   dataend_time = ''
   numlines = len(lines)
   for iline in range(0,numlines):
      if lines[numlines-iline-1].split(':')[0] == 'new_profile':
         matchobj = re.findall(pat, lines[numlines-iline-1])
         if len(matchobj) > 0:
            dataend_time = matchobj[0]
            dataend_dd = ddtime(dataend_time, str(opts['yearbase']))
            break
   opts['thisload_time_range'] = opts['thisload_time_range'] + ' to ' + dataend_time
   opts['thisload_enddd'] = dataend_dd
   print 'time range of data to be loaded: %s'%(opts['thisload_time_range'])
   print '(%f to %f)' %(opts['thisload_startdd'], opts['thisload_enddd'])


   # ok_cmdlist was already trimmed
   atlist = ['@'+ ok_cmdlist[ii] for ii in range(0,len(ok_cmdlist))]
   ldcodas_cnt = ldcodas_cnt + string.join(atlist, '\n') + '\nend\n'
   
   print ldcodas_cnt
   ld = open(cntfile, 'w')
   ld.write(ldcodas_cnt)
   ld.close()

