#! /usr/bin/env python
''' adcpsect_part2.py  Interface to retrieve minimum input necessary to run the
gridding program(s) and run adcpsect in order to produce
the data files needed for the plotting programs.
   Usage: >adcpsect.py  --> which calls this -->adcpsect_part2.py 1 2
   (from adcpsect.py), where:
       sys.argv[1] is the database name (as *dir.blk)
       sys.argv[2] is the output path
'''

import os, string, sys, os.path
import FileDialog, tkMessageBox
from Tkinter import *
# do not import Pmw

mainwindow2 = Tk()
mainwindow2.title('           ADCP Data Processing')
mainwindow2.geometry('+200+100')

class ADCPproc:
    def __init__(self, master = None):
        self.master = master
        self.stopflag = 0
        self.f1 =  Frame(master, width = 650, height = 425, relief = RAISED, bd = 2)
        self.lbltitle =  Label(self.f1, text = 'ADCP DATA SETUP',
                               font = (('MS','Sans','Serif'),'18'), fg = 'blue' )            
        self.dbname = StringVar()
        self.dbname.set(sys.argv[1])
        self.dbnameshort = self.dbname.get()
        self.dbnameshort = self.dbnameshort[0:-7]
        self.pnout = StringVar()
        self.pnout.set(sys.argv[2])
        self.lbldbname =  Label(self.f1, text = 'Using: ' + self.dbname.get())
        self.lbloutpath =  Label(self.f1, text = 'Outpath: ' + self.pnout.get())
        
        self.lblvertical = Label(self.f1, text = 'Vertical grid:', relief = RAISED, bg = 'light blue')
        self.varvert = IntVar()
        self.radiovg = Radiobutton(self.f1, text = 'Increment', variable = self.varvert, value = 1,
                                   command = self.toggle_vert)
        self.lblvgstart = Label(self.f1, text = 'Start at (m):')
        self.vgstart = StringVar()
        self.vgstart.set('21')
        self.editvg = Entry(self.f1, textvariable = self.vgstart,
                             width = 5, bg = 'white')
        self.lblvginc = Label(self.f1, text = 'Vert. increment (m):')
        self.vginc = StringVar()
        self.vginc.set('10')
        self.editvginc = Entry(self.f1, textvariable = self.vginc,
                             width = 5, bg = 'white')
        self.lblvgpts = Label(self.f1, text = 'No. of pts.:') #,state = DISABLED
        self.vgpts = StringVar()
        self.vgpts.set('45')
        self.editvgpts = Entry(self.f1, textvariable = self.vgpts,
                             width = 5, bg = 'white') #,state = DISABLED, fg = 'gray'

               
        self.radiovb = Radiobutton(self.f1, text = 'Boundaries', variable = self.varvert, value = 2,
                                   command = self.toggle_vert)
        self.vb = StringVar()
        self.vb.set('25 75 125 175 225 275 325 375 425') #('21 50 75 100 200 300 400')
        self.editvb = Entry(self.f1, textvariable = self.vb,
                             width = 23, bg = 'white', state = DISABLED, fg = 'gray')


        self.lblbins =  Label(self.f1, text = 'No. bins:')
        self.bins = StringVar()
        self.bins.set('60')
        self.editbins = Entry(self.f1, textvariable = self.bins,
                                 width = 7, bg = 'white')

        self.lblprefix =  Label(self.f1, text = "Outfiles' prefix:")
        self.prefix = StringVar()
        self.prefix.set('c_sect')
        self.editprefix = Entry(self.f1, textvariable = self.prefix,
                                 width = 7, bg = 'white')

        self.lbltimerange =  Label(self.f1, text = 'Time range:',relief = RAISED, bg = 'light blue')
        self.timerange = StringVar()
        #trtight = sys.argv[3] # compressed to send as single arg
        #tr = '%s %s to %s %s' %(trtight[0:10], trtight[10:18], trtight[18:28], trtight[28:])
        tr = sys.argv[3]
        print 'timerange is<' + tr + '>'        
        self.timerange.set(tr) 
        self.edittimerange = Entry(self.f1, textvariable = self.timerange,
                                 width = 36, bg = 'white')
        
        self.yearbase = StringVar()
        #self.yearbase.set(trtight[0:4])
        self.yearbase.set(tr[0:4])
        self.lblyear =  Label(self.f1, text = 'Year base:')
        self.edityear = Entry(self.f1, textvariable = self.yearbase,
                                 width = 7, bg = 'white')

        self.lblnavref = Label(self.f1, text  = 'Navigation reference:', relief = RAISED, bg = 'light blue')
        self.varnav = IntVar()
        self.radionavship = Radiobutton(self.f1, text = 'Final ship ref', variable = self.varnav, value = 1)
        self.radionavbottom = Radiobutton(self.f1, text = 'Bottom track', variable = self.varnav, value = 2)

        self.lblcontour = Label(self.f1, text = 'ASCII contour file ordinate:', relief = RAISED, bg = 'light blue')
        self.varcont_ord = IntVar()
        self.radiocont_none = Radiobutton(self.f1, text = 'No file', variable = self.varcont_ord, value = 1)
        self.radiocont_lat = Radiobutton(self.f1, text = 'Latitude (.con) file', variable = self.varcont_ord, value = 2)
        self.radiocont_lon = Radiobutton(self.f1, text = 'Longitude (.con) file', variable = self.varcont_ord, value = 3)
        self.radiocont_time = Radiobutton(self.f1, text = 'Time (.con) file', variable = self.varcont_ord, value = 4)
    
        self.lblvector = Label(self.f1, text = 'ASCII vector file:', relief = RAISED, bg = 'light blue')
        self.varvec = BooleanVar()
        self.checkvec = Checkbutton(self.f1, text = 'Yes (.vec) file <off = none>',
                                    variable = self.varvec)

        self.lblgrid = Label(self.f1, text = 'Extract data by:', relief = RAISED, bg = 'light blue')
        self.lblgrid2 = Label(self.f1, text = '----------------------------------------------------------------------')
        self.vargrid = IntVar()
        self.radiotimegrid = Radiobutton(self.f1, text = 'Time grid (mins):', variable = self.vargrid,
                                       value = 1, command = self.toggle_extract)
        self.time = StringVar()
        self.time.set('60')
        self.edittime = Entry(self.f1, textvariable = self.time,
                                    width = 5, bg = 'white', fg = 'gray', state = DISABLED)
        
        self.radiollgrid = Radiobutton(self.f1, text = 'Lat/Lon grid (step):', variable = self.vargrid,
                                       value = 2, command = self.toggle_extract)
        self.ll = StringVar()
        self.ll.set('0.1')
        self.editll = Entry(self.f1, textvariable = self.ll,
                                    width = 5, bg = 'white')        
        self.radiotrack = Radiobutton(self.f1, text = 'Track dist. (km):', variable = self.vargrid,
                                       value = 3, command = self.toggle_extract, state = DISABLED)
        self.distance = StringVar()
        self.distance.set('10')
        self.editdistance = Entry(self.f1, textvariable = self.distance,
                                  width = 5, bg = 'white', state = DISABLED,
                                  fg = 'gray')
        self.radioall = Radiobutton(self.f1, text = 'All profiles', variable = self.vargrid,
                                       value = 4, command = self.toggle_extract)
        self.radiopreviousfile = Radiobutton(self.f1, text = 'Previous file:', variable = self.vargrid,
                                       value = 5, command = self.toggle_extract)
        self.pfile = StringVar()
        self.pfile.set(self.pnout.get()) #os.getcwd())
        self.editpfile = Entry(self.f1, textvariable = self.pfile,
                                 width = 33, bg = 'white', fg = 'gray', state = DISABLED)
        self.btnpfile = Button(self.f1, text = '. . .', width = 1,
                                font = (('MS','Sans','Serif'),'9','bold'),
                                command = self.filefindprev, state = DISABLED)
        
        self.lblscale = Label(self.f1, text = 'PG cutoff:')
        self.scale = StringVar()
        self.scale.set('50')
        self.editscale = Entry(self.f1, textvariable = self.scale,
                                 width = 7, bg = 'white')

        self.btnOK = Button(self.f1, text = 'Run adcpsect', command = self.btnOKed, fg = 'blue')
        self.btnCancel = Button(self.f1, text = 'Exit', command = self.f1.quit)
        self.btnBack = Button(self.f1, text = 'Back...', command = self.backup, fg = 'dark blue')

#_______________________________________________
        
        self.f1.pack()
        self.lbltitle.place(relx = .5, rely = .07, anchor = CENTER)
        self.lbldbname.place(relx = .5, rely = .14, anchor = CENTER)
        self.lbloutpath.place(relx = .5, rely = .18, anchor = CENTER)
        
        self.lblvertical.place(relx = .05, rely = .25, anchor = W)        
        self.radiovg.place(relx = .05, rely = .3, anchor = W)# Increment
        self.lblvgstart.place(relx = .09, rely = .35, anchor = W)#'Start at (m):')
        self.editvg.place(relx = .29, rely = .35, anchor = W) # '30'                  
        self.lblvginc.place(relx = .09, rely = .4, anchor = W)# 'Vert. increment (m):')
        self.editvginc.place(relx = .29, rely = .4, anchor = W) # '20'
        self.lblvgpts.place(relx = .09, rely = .45, anchor = W)#'No. of pts.:')
        self.editvgpts.place(relx = .29, rely = .45, anchor = W)# '20'
        
        self.radiovb.place(relx = .05, rely = .5, anchor = W)# Boundaries
        self.editvb.place(relx = .09, rely = .55, anchor = W)
        
        self.lblnavref.place(relx = .72, rely = .25, anchor = W)
        self.radionavship.place(relx = .72, rely = .3, anchor = W)
        self.radionavbottom.place(relx = .72, rely = .35, anchor = W)

        self.lblvector.place(relx = .39, rely = .25, anchor = W)
        self.checkvec.place(relx = .39, rely = .3, anchor = W)

        self.lblcontour.place(relx = .39, rely = .375, anchor = W)
        self.radiocont_none.place(relx = .39, rely = .425, anchor = W)
        self.radiocont_lat.place(relx = .39, rely = .47, anchor = W)
        self.radiocont_lon.place(relx = .39, rely = .52, anchor = W)
        self.radiocont_time.place(relx = .39, rely = .57, anchor = W)
        
        self.lblyear.place(relx = .84, rely = .42, anchor = E)
        self.edityear.place(relx = .84, rely = .42, anchor = W)
        self.lblbins.place(relx = .84, rely = .47, anchor = E)
        self.editbins.place(relx = .84, rely = .47, anchor = W)
        self.lblprefix.place(relx = .84, rely = .52, anchor = E)
        self.editprefix.place(relx = .84, rely = .52, anchor = W)
        self.lblscale.place(relx = .84, rely = .57, anchor = E)
        self.editscale.place(relx = .84, rely = .57, anchor = W)

        self.lblgrid.place(relx = .05, rely = .63, anchor = W)
        self.lblgrid2.place(relx = .24, rely = .63, anchor = W)
        self.radiotimegrid.place(relx = .05, rely = .68, anchor = W)
        self.edittime.place(relx = .29, rely = .68, anchor = W) # '30'
        self.radiollgrid.place(relx = .05, rely = .73, anchor = W)
        self.editll.place(relx = .29, rely = .73, anchor = W) # '0.1'
        self.radiopreviousfile.place(relx = .05, rely = .78, anchor = W)
        self.radiotrack.place(relx = .39, rely = .68, anchor = W)
        self.editdistance.place(relx = .59, rely = .68, anchor = W) # '10'
        self.radioall.place(relx = .39, rely = .73, anchor = W)
        self.editpfile.place(relx = .09, rely = .83, anchor = W)
        self.btnpfile.place(relx = .46, rely = .83, anchor = W)

        self.lbltimerange.place(relx = .54, rely = .77, anchor = W)
        self.edittimerange.place(relx = .54, rely = .83, anchor = W)

        self.btnCancel.place(relx = .3, rely = .925, anchor = E)
        self.btnBack.place(relx = .54, rely = .925, anchor = E)
        self.btnOK.place(relx = .65, rely = .925, anchor = W)
#_______________________________________________

        inweb = string.find(os.getcwd(), 'htdocs')
        if inweb > -1:
           self.time.set('15')
           self.vargrid.set(1)
           self.toggle_extract


    def toggle_vert(self):
        if self.varvert.get() == 1:
            self.lblvgstart.configure(state = NORMAL)
            self.editvg.configure(fg = 'black')
            self.editvg.configure(state = NORMAL)
            self.lblvginc.configure(state = NORMAL)
            self.editvginc.configure(state = NORMAL)
            self.editvginc.configure(fg = 'black')
            self.lblvgpts.configure(state = NORMAL)
            self.editvgpts.configure(fg = 'black')
            self.editvgpts.configure(state = NORMAL)
            
            self.editvb.configure(state = DISABLED, fg = 'gray')

            self.vargrid.set(2)
            self.toggle_extract()
            self.prefix.set('c_sect')
        else:            
            self.lblvgstart.configure(state = DISABLED)
            self.editvg.configure(fg = 'gray')
            self.editvg.configure(state = DISABLED)
            self.lblvginc.configure(state = DISABLED)
            self.editvginc.configure(state = DISABLED)
            self.editvginc.configure(fg = 'gray')
            self.lblvgpts.configure(state = DISABLED)
            self.editvgpts.configure(fg = 'gray')
            self.editvgpts.configure(state = DISABLED)
            
            self.editvb.configure(state = NORMAL, fg = 'black')

            self.vargrid.set(1)
            inweb = string.find(os.getcwd(), 'htdocs')
            if inweb > -1:
                self.time.set('60')
            self.toggle_extract()
            self.prefix.set('v_sect')


    def toggle_extract(self):
        self.radiocont_lat.configure(state = NORMAL) # may have been disabled with ALL
        self.radiocont_lon.configure(state = NORMAL)
        self.radiocont_time.configure(state = NORMAL)
        if self.vargrid.get() == 1: # on time
            self.edittime.configure(fg = 'black', state = NORMAL)
            self.editll.configure(fg = 'gray', state = DISABLED)
            self.editpfile.configure(fg = 'gray', state = DISABLED)
            self.btnpfile.configure(state = DISABLED)
        elif self.vargrid.get() == 2: # on lat/long
            self.edittime.configure(fg = 'gray', state = DISABLED)
            self.editll.configure(fg = 'black', state = NORMAL)
            self.editpfile.configure(fg = 'gray', state = DISABLED)
            self.btnpfile.configure(state = DISABLED)
        elif self.vargrid.get() == 4:  # on all
            self.edittime.configure(fg = 'gray', state = DISABLED)
            self.editll.configure(fg = 'gray', state = DISABLED)
            self.editpfile.configure(fg = 'gray', state = DISABLED)
            self.btnpfile.configure(state = DISABLED)
            self.radiocont_none.select()
            self.radiocont_lat.configure(state = DISABLED)
            self.radiocont_lon.configure(state = DISABLED)
            self.radiocont_time.configure(state = DISABLED)
        else: # == 5 with previous file
            self.edittime.configure(fg = 'gray', state = DISABLED)
            self.editll.configure(fg = 'gray', state = DISABLED)
            self.editpfile.configure(fg = 'black', state = NORMAL)
            self.btnpfile.configure(state = NORMAL)
    
    def filefindprev(self):
        findprev = FileDialog.FileDialog(self.f1)
        pattern = self.prefix.get() + '.*'
        pv = findprev.go(display.pfile.get(),pattern) 
        if pv is None: print 'cancelled'
        else:
            self.pfile.set(pv)
            
    def llgrid(self): 
        dbn = display.dbnameshort
        outf = '%s/%s.llg' %(self.pnout.get(), self.prefix.get())
        year_base = self.yearbase.get()
        latint = self.ll.get() 
        lonint = self.ll.get() 
        lato = -0.5*float(latint)
        lono = -0.5*float(lonint)
        tr = display.timerange.get()
        
        ll_cnt_str = '''
          dbname:             %(dbn)s
          output:             %(outf)s
          year_base:          %(year_base)s
          step_size:          1        /* must be 1 for navigation */

          lat_origin:           %(lato).2f
          lat_increment:        %(latint)s
          lon_origin:           %(lono).2f
          lon_increment:        %(lonint)s

          time_ranges:          %(tr)s

        '''
        fname = '%s/%s_llg.cnt' %(self.pnout.get(), self.prefix.get())
        ll_template = open(fname, 'w')    
        ll_template.write(ll_cnt_str % vars())
        ll_template.close()
        runstr = 'llgrid %s' %(fname)
        os.system(runstr)
        self.gridfilename = outf
        
    def timegrid(self):
        filen = '%s/%s.tmg' %(self.pnout.get(), self.prefix.get())
        t_int = display.time.get()
        t_rng = display.timerange.get()
        time_cnt_str = '''
            output:             %(filen)s
            time_interval:      %(t_int)s
            time_range:         %(t_rng)s
            '''
        fname = '%s/%s_tmg.cnt' %(self.pnout.get(), self.prefix.get())
        time_template = open(fname, 'w')    
        time_template.write(time_cnt_str % vars())
        time_template.close()
        runstr = 'timegrid %s' %(fname)
        os.system(runstr)
        self.gridfilename = filen

    def backup(self):
        mainwindow2.withdraw()  
        sysstr = 'adcpsect.py -d %s -o %s' %(display.dbname.get(),
                                          display.pnout.get()) 
        os.system(sysstr)
        self.btnCancel.invoke()      
            
    def btnOKed(self): 
        dbname = display.dbnameshort
        fileoutnm = self.pnout.get() + '/' + self.prefix.get()
        ndep = self.bins.get()
        yb = self.yearbase.get()
        regridline = '''
            regrid:           average
                              depth
            '''
        timer = 'separate'
        vgstart = self.vgstart.get() 
        vginterval = self.vginc.get() 
        vgpoints = self.vgpts.get() 
        vboundaries = self.vb.get() 
        vboundaries = string.strip(vboundaries)
        vboundaries = string.replace(vboundaries, '  ', ' ')
        vboundaries = string.replace(vboundaries, '  ', ' ')
        vboundaries = string.replace(vboundaries, '  ', ' ')
        vbcount = string.count(vboundaries, ' ') + 1
        if self.vargrid.get() == 1: # time grid
            self.timegrid()
        if self.vargrid.get() == 2: # lat/long grid
            self.llgrid()
        if self.vargrid.get() == 5: # use previous file (3: unavail, 4: above)
            self.gridfilename = self.pfile.get()
        if self.varvert.get() == 1: # increments
            gridline1 = 'grid number= %s' %vgpoints  
            gridline2 = 'origin= %s' %vgstart
            gridline3 = 'increment= %s' %vginterval
        else:
            gridline1 = 'grid_list number= %d' %vbcount
            gridline2 = 'boundaries: %s' %vboundaries
            gridline3 = ' '
        if self.vargrid.get() == 4: # all
            gridfilenm = display.timerange.get()  #'all'
            timer = 'single'
            tkMessageBox.showinfo('Note','This may take several minutes.')
        else:
            gridfilenm = '@ %s' %(self.gridfilename) # needed to isolate 'all' version    
        pgmin = display.scale.get()
        if self.varnav.get() == 1:
            reftype = 'final_ship_ref'
        else:
            reftype = 'bottom_track'

        conttype = self.varcont_ord.get()
        if conttype == 1:   # no file
            contline1 = ' '
            contline2 = ' '
        elif conttype == 2: # latitude
            contline1 = 'contour: latitude\n  mean\n  minimum_npts= 2\n '
            contline2 = 'units= 5'
        elif conttype == 3: # longitude
            contline1 = 'contour: longitude\n  mean\n  minimum_npts= 2\n '
            contline2 = 'units= 5'
        else :              # time
            contline1 = 'contour: time\n  mean\n  minimum_npts= 2\n '
            contline2 = 'units= 0.01'

        if not self.varvec.get():
            vectline = ' '
        else:
            vectline = 'vector:   minimum_npts= 2'

        asect_cnt_str = '''
          dbname:             %(dbname)s
          output:             %(fileoutnm)s
          step_size:          1        /* must be 1 for navigation */
          ndepth:             %(ndep)s        /* may chg to 128 */
          time_ranges:        %(timer)s
          year_base=          %(yb)s
          option_list:
            pg_min=           %(pgmin)s
            reference:        %(reftype)s
            %(regridline)s
                              %(gridline1)s
                              %(gridline2)s
                              %(gridline3)s
            %(contline1)s
            %(contline2)s
            %(vectline)s
            flag_mask:        ALL_BITS
              end
            end

          %(gridfilenm)s
        '''

        fname = '%s/%s_adcp.cnt' %(self.pnout.get(), self.prefix.get())
        as_template = open(fname, 'w')    
        as_template.write(asect_cnt_str % vars())
        as_template.close()
        runstr = 'adcpsect %s/%s_adcp.cnt' %(self.pnout.get(), self.prefix.get())
        os.system(runstr)

        pre = '   ' + display.prefix.get()
        dirn, fn1 = os.path.split(fname)
        fn1 = '   ' + fn1 + '   '
        if self.vargrid.get() == 1: 
            fn2 = pre + '_tmg.cnt'
        elif self.vargrid.get() == 2:
            fn2 = pre + '_llg.cnt'
        else:
            fn2 = ''
        if self.vargrid.get() == 4: fn3 = ''
        else:
            dirgrid, fn3 = os.path.split(self.gridfilename)
            fn3 = '   ' + fn3
        if conttype <> 1: fn4 = pre + '.con'
        else: fn4 = ''
        if self.varvec.get(): fn5 = pre + '.vec'
        else: fn5 = ''
        minout = '%s_uv.mat\n%s_xy.mat\n%s.sta' %(pre, pre, pre)             
        filelist = 'Control files:      \n%s\n%s\n\nData files:\n%s\n%s\n%s\n%s' %(fn1, fn2, minout, fn3, fn4, fn5)
        
        chk1 = '%s/%s_uv.mat' %(dirn, string.strip(pre))
        chk2 = '%s/%s_xy.mat' %(dirn, string.strip(pre))
        chk3 = '%s/%s.sta' %(dirn, string.strip(pre))

        if os.path.isfile(chk1) and os.path.isfile(chk2)and os.path.isfile(chk3):
            if os.path.getsize(chk1) < 50 or os.path.getsize(chk2) < 50 or os.path.getsize(chk3) < 50:
                tkMessageBox.showinfo('Problem','Data not extracted')
            else:
                tkMessageBox.showinfo('Finished',filelist)
        else:
            print chk2
            tkMessageBox.showinfo('Problem','Data not extracted')


display = ADCPproc(mainwindow2)
display.radiovg.select()
display.radiollgrid.select()
inweb = string.find(os.getcwd(), 'htdocs')
if inweb > -1:
   display.radiotimegrid.select()
   display.edittime.configure(fg = 'black', state = NORMAL) # self.toggle.extract not grabbing above ?
   display.editll.configure(fg = 'gray', state = DISABLED)
display.radionavship.select()
display.radiocont_none.select()    
#if __name__ ==  '__main__':
mainwindow2.mainloop()



