C ***********************************************************************
C ***********************************************************************
 	SUBROUTINE ICS(nn,ntv,bathy,pbed,pinit,c,gbc)            
C ----------------------------------------------------------------------
C
C This subroutine is called once per simulation during the initialization 
C stage of the core program. The purpose is to define the initial 
C concentration field (vertically averaged volumetric quantity)
C
C inputs: nn is the number of horizontal nodes
C         ntv is the number of transport variables
C         casnam is the character string of the mesh case name
C         x(nn), y(nn) are the cartesian compenents of the mesh nodes
C	   kd, ssec are the timing paramters (integer gregorian day and C		   seconds after midnight)
C	   iter is the number of time steps since the beginning of the C			simulation
C	    sv(nn) is the mass matrix   
C	    bathy(nn) is the bathymetric depth of the water at each node
C
C outputs: c(nn) the concentration field defined as a nodal quanitity
C	     c(x,y) has units of (#/m^3) and represents the 
C 	       vertically averaged concentration at location (x,y)
C
C -----------------------------------------------------------------------
	include 'ACADIA.DIM'

C Global variables
	integer nn, ntv
	real c(nndim), bathy(nndim)
        real pbed(nndim),pinit(nndim),gbc(nndim)
	
C read initial cyst bed data
C set compensation depth, GB (the nearest to the bottom T,S depth level),
C and cysts migration time delay GBC    

        CALL INITCYST(nn,bathy,pbed,pinit,gbc)

        do i=1,nn
          c(i)=0.0
        end do

       return
      end
C ***********************************************************************
C ***********************************************************************
	SUBROUTINE OUTPUT(NN,ntv,NE,CASNAM,kd,ssec,iter,delt,
     &       u,v,bathy,C,pinit,pbed,pgerm,flx,flxb,cflx,gbc)

C ----------------------------------------------------------------------
C
C This subroutine is called once every time step. It is intended for 
C the user to be able to save desired quanities and no calculation is
C expected by the code
C
C inputs: nn is the number of horizontal nodes
C         ntv is the number of transport variables
C         ne is the number of elements in the mesh
C         casnam is the character string of the mesh case name
C	   kd, ssec are the timing paramters (integer gregorian day and C		   seconds after midnight)
C	   iter is the number of time steps since the beginning of the C		   simulation
C	    delt is the time step in seconds    
c         SV(nn) is the mass matrix
C	    u(nn), v(nn) are the current nodal values of the   
C		 cartesian components of velocity in m/s  
C         ah(nn) is the current values of the nodal diffusivities in m^2/s      C	    bathy(nn) is the bathymetric depth of the water at each node
C	    c(x,y) has units of (#/m^3) and represents the 
C 	       vertically averaged concentration at location (x,y) at time 
C 	       kd, ssec
C
C -----------------------------------------------------------------------
	include 'ACADIA.DIM'

C Global variables
	character*72, casnam
	integer kd,nn,ne,ntv,iter
	real ssec,c(nndim), bathy(nndim), pinit(nndim),
     &  pbed(nndim),pgerm(nndim),flx(nndim),flxb(nndim)
	real delt u(nndim), v(nndim),cflx(nndim),gbc(nndim) 
C local variables
	character*72 prefix,header,filnam
	character*20 day,month,year,time,filnum
	character*1 blank
	integer count, id, im, iy, is, in, indx
	save count
	
	blank=' '
 	prefix='out'
	indx=index(prefix,' ')-1      
C Save the desired elevations 
       if(MOD(iter,288).EQ.0)then
	  call inttochr(count,filnum,in)
	  filnam=prefix(1:indx)//filnum(1:in)//'.s2r'	
	  open (unit=21,file='./ac7_out/'//filnam)
	  write(21,*) 'g2s.5b'
	  call dmy(idd0,imm0,iyear0,kd)
	  call inttochr(idd0,day,id)
	  call inttochr(imm0,month,im)
	  call inttochr(iyear0,year,iy)
	  call inttochr(int(ssec),time,is)
	  header=day(1:id)//blank//month(1:im)//blank//
     &         year(1:iy)//blank//time(1:is)

	  write(21,*) header

c output totals

	  do i=1,nn
          write(21,'(i5,E12.3)') i,c(i)
	  end do
         count=count+1
	end if
	return
	end
C ***********************************************************************
C ***********************************************************************
      SUBROUTINE rxn(nn,ntv,bday,delt,kd,iter,bathy,gbc,pinit,pbed,
     &     flx,flxb,cflx,pgerm,rc)
C ----------------------------------------------------------------------
C
C This subroutine is called at every time step. It is used to specify the 
C rate of local generation or decay (and potential coupling) of 
C the concentration of each transport variable 
C 
C inputs: nn is the number of horizontal nodes
C         ntv is the number of transport variables
C	   iter is the number of time steps since the beginning of the C		   simulation
C	   kd, ssec are the timing paramters (integer gregorian day and C		   seconds after midnight)
C         x(nn), y(nn) are the cartesian compenents of the mesh nodes 
C	    u(nn),v(nn) are the cartesian components of the current nodal
C            nodal values of velocity    
C         ah(nn) is the current value of the nodal diffusivities 
c         SV(nn) is the array of nodal areas (1/3 of the area of each
C		   element using that node
C	    bathy(nn) is the bathymetric depth of the water at each node
C	    c(ntv, nn) has units of (#/m^3) and represents the 
C 	       vertically averaged concentration at time kd,ssec
C 	
C output: rc(ntv,nn) which is the local reaction term in units of
C         reciprocal seconds.
C
C -----------------------------------------------------------------------
	include 'ACADIA.DIM'


C Global variables
      real rc(nndim),gbc(nndim),pinit(nndim),pbed(nndim),
     &  pgerm(nndim)
      real bathy(nndim),flx(nndim),flxb(nndim),cflx(nndim)
      integer nn,ntv,kd,bday,iter
      real delt

c set the germination rate
        CALL CELLFLUX(nn,bday,bathy,delt,gbc,pinit,pbed,
     &  flx,flxb,cflx,pgerm,iter)
c set up growth rate
        CALL DINOGROW(nn,bathy,rc,c,iter)
c rates for population growth are per day (time step is seconds)

      return
      end

C ***********************************************************************
C ***********************************************************************
	subroutine bcs(ntv,casnam,x,y,bathy,
     &               u,v,delt,sv,iter,kd,ssec,c,rhsc)
C ----------------------------------------------------------------------
C
C This subroutine is used to specify the boundary conditions applied 
C at every time step. For the non-conservative transport equation
C the natural boundary conditions (what is assumed if nothing is applied) 
C are no normal diffusive flux
C
C inputs: ntv is the number of transport variables
C         casnam is the character string of the mesh case name
C         x(nn), y(nn) are the cartesian compenents of the mesh nodes
C	    bathy(nn) is the bathymetric depth of the water at each node
C	    u(nn),v(nn) are the cartesian components of the current nodal
C            nodal values of velocity
C	    delt is the time step in seconds     
c         SV(nn) is the array of nodal areas (1/3 of the area of each
C		   element using that node
C	   iter is the number of time steps since the beginning of the C		   simulation
C	   kd, ssec are the timing paramters (integer gregorian day and C		   seconds after midnight)
C	    c(ntv, nn) has units of (#/m^3) and represents the 
C 	       vertically averaged concentration at time kd,ssec
C 	
C output: rhsc(ntv,nn) is the right hand side of the explicit equation
C		 that will be used to integrate C in time. Application of all C		 boundary conditions will be done by changing this 
C 		 right-hand-side
C -----------------------------------------------------------------------

	include 'ACADIA.DIM'
C Global variables
	integer ntv, iter, kd
	real x(nndim), y(nndim), bathy(nndim)
	real u(nndim), v(nndim), sv(nndim)
	real c(nndim), rhsc(nndim)
	real ssec, delt
	character*72 casnam

C local vaariables
	integer nbedim
	parameter (nbedim=700)
	character*72 belfil
	real xl(2),yl(2)
	real dxb(nbedim),dyb(nbedim),unorm(nbedim,2),dsb(nbedim)
	integer inb(nbedim,2), jl(2), iflow(nbedim,2)
	integer ibc1(nedim), ibc2(nedim)

	save nbe,dxb,dyb,dsb,iflow,unorm,ifldold,ibc1,ibc2,inb

	if (iter.ne.0)  go to 10
C initialization call

C Calculation of Elemental Normal and Elemental DeltaS
C dsb(element) 				= deltas
c (-dyb(l)/dsb(l), dxb(l)/dsb(l))	=elemental normal

	call cstring(casnam, lms,lme)
	belfil=casnam(lms:lme)//'.bel'
	open (unit=23, file=belfil)
	write(2,*) 'boundary condition file:',belfil
	read (23,'(a)') header
	read (23,'(a)') header

c get normals to elements and 
c determine if inflow, noflow, or outflow boundary node
      do 5 l=1,nbedim
	  read (23,*,end=6) nbe, inb(l,1), inb(l,2), ibc1(l), ibc2(l)
	  jl(1)=inb(l,1)
	  jl(2)=inb(l,2)	 
	  xl(1)=x(jl(1))
	  yl(1)=y(jl(1))
	  xl(2)=x(jl(2))
	  yl(2)=y(jl(2))
	  dxb(l)=xl(2)-xl(1)
	  dyb(l)=yl(2)-yl(1)
	  dsb(l)=sqrt((dxb(l)**2)+(dyb(l)**2))
 5    continue
         write(2,*)' Potential error reading .bel file =>',
     &            ' increase nbedim such that it exceeds the number of',
     &            ' nodes by at least 1 and recompile.'
         stop
 6	continue

 10	continue

c determine type of boundary conditions
	if (iter.eq.0) then	
c determine boundary condition based on bel file values
c this assumes that bel file lists the nodes connectedly and
c in a counterclockwise manner
	  do l=1,nbe
	    jl(1)=inb(l,1)
	    jl(2)=inb(l,2)	
c if the material outside is land or island
	    if ((ibc2(l).eq.1).or.(ibc2(l).eq.2)) then
	      do j=1,2
	        iflow(l,j)=2
ccc	    write(2,*) 'node:',jl(j), '(is)land'
		end do
c if open boundary
	  else
c calculate the normal velocity
	    unorm(l,1)=(u(jl(1))*dyb(l)-v(jl(1))*dxb(l))/dsb(l)
	    unorm(l,2)=(u(jl(2))*dyb(l)-v(jl(2))*dxb(l))/dsb(l)

	    do j=1,2
c inflow boundaries
	      if (unorm(l,j).lt.0.) then
	        iflow(l,j)=1
	    write(2,*) 'node:',jl(j), 'inflow'
c outflow boundaries
	      else if (unorm(l,j).ge.0.) then
	        iflow(l,j)=2
ccc	    write(2,*) 'node:',jl(j), 'outflow'
	      endif
	    end do
	  end if
	end do


c make adjustment to corners (choose which condition dominates)
c (right now type 1 takes dominance over type 2 or type 3
c		 type 2 takes dominance over type 3)
c this assumes that bel file lists the nodes connectedly and
c in a counterclockwise manner

	  l1=1
	  do l=1,nbe
	    if (inb(l,2).eq.inb(l+1,1)) then
	       ll=l+1
	    else
		 ll=l1
	       l1=l+1
	    end if
	    if (iflow(l,2).ne.iflow(ll,1)) then
	      if ((iflow(l,2).eq.1).or.(iflow(ll,1).eq.1)) then	      
 	        iflow(l,2)=1
	        iflow(ll,1)=1
		else
	 	  iflow(l,2)=2
	        iflow(ll,1)=2
	      end if
	    end if
	  end do

c apply type 1 bc values
c (right now all type 1's are zero)
c	  do l=1,nbe
c	    if(iflow(l,1).eq.1) then
c		do m=1,ntv
c		  c(m,inb(l,1))=0.0
c		end do
c	    end if 
c	  end do

	end if

c Apply Boundary Conditions 
	  do l=1,nbe
	   do j=1,2
	     jj=inb(l,j)
c type 1's (do no change)
	     if (iflow(l,j).eq.1) then
ccc		  do m=1,ntv
	          rhsc(jj)=0.
ccc	     	  end do 	
c type 2's (right now are zero)
		elseif(iflow(l,j).eq.2) then
ccc		  do m=1,ntv
	          rhsc(jj)=rhsc(jj)+0.
ccc	     	  end do	
	     end if
	  end do	
	 end do


	return 
	end

C ***********************************************************************
C ***********************************************************************
 	subroutine get_physics(casnam,NN,ne,deg,kd,ssec,
     &                      iter,x,y,bathy,u,v,ah,iahchg,rday)
C ----------------------------------------------------------------------
C
C This subroutine is used to specify the values of the physical 
C transport parameters at time kd, ssec. It is called every time step.
C To improve the efficiency of the computation, the main code needs to 
C be told whether or not ah has changed since the last itteration. 
C This is done with the flag iahchg. 
C 
C inputs: casnam is the character string of the mesh case name
C         nn is the number of nodes on the horizontal mesh
C	    ne is the number of elements
C	    deg is the degrees latitude of the center of the mesh
C	   iter is the number of time steps since the beginning of the C		   simulation
C	   kd, ssec are the timing paramters (integer gregorian day and C		   seconds after midnight)
C         x(nn), y(nn) are the cartesian compenents of the mesh nodes
C	    bathy(nn) is the bathymetric depth of the water at each node
C 	
C output: u(nn),v(nn) are the cartesian components of the current nodal
C            nodal values of velocity (units of m/s)
C	    ah(nn) is the horizontal diffusivity (units of m^2/s)
C	    iahchg the integer flag informing the main code if the 
C 	       physical values have varied in time (info used bu other 
C		 parts of the code)
C	    iahchg=0   --- values are same as thos eat last time step
C         iahchg=1   --- values have changed since last time step
C -----------------------------------------------------------------------
C
	include 'ACADIA.DIM'

C Global Variables
	character*72 casnam
	integer nn, ne, kd, iter
	real deg, ssec
	real x(nndim), y(nndim), u(nndim), v(nndim), ah(nndim)
	real bathy(nndim)
	integer iahchg,rday

C local variables
	integer nnvdim
	parameter (nnvdim=21)
        real z(nndim,nnvdim)
	complex u3(nndim,nnvdim),v3(nndim,nnvdim),w3(nndim,nnvdim)
	complex ubar(nndim),vbar(nndim)
	character*72 velfil, hdiffil
	real ampu(nndim),phaseu(nndim)
	real ampv(nndim),phasev(nndim)
	real ampah(nndim), phaseah(nndim)
	real scval(nndim)

c load in the desired zero-frequency vel files and vertically average them
C load in the horizontal diffusivities

        if (rday.le.120) then
	velfil='./MA/residlag.vel' 
	hdiffil='./MA/resahi.s2r'
        else
        if ((rday.gt.120).and.(rday.le.181)) then
	velfil='./MJ/residlag.vel' 
	hdiffil='./MJ/resahi.s2r'
        else
        velfil='./JA/residlag.vel'
        hdiffil='./JA/resahi.s2r'
        end if
        end if

	if ((iter.eq.0).OR.(iter.eq.(288*61+1)).
     &  OR.(iter.eq.(288*122+1))) then
	call loadvel(nndim,nnvdim,nn,nnv,velfil,z,u3,v3,w3)
	call vertavgc(u3,ubar,z,nn,nnv,nndim,nnvdim)
	call vertavgc(v3,vbar,z,nn,nnv,nndim,nnvdim)

	do i=1,nn
	ampu(i)=cabs(ubar(i))
	ampv(i)=cabs(vbar(i))
	phaseu(i)=phaselagd(ubar(i))
	phasev(i)=phaselagd(vbar(i))
	end do

	call loads2r(nndim,nn,hdiffil,scval)

	do i=1,nn
	ampah(i)=scval(i)
	phaseah(i)=0.
	end do

c compute residual terms (phase lag is included in case a phase 
C of pi has resultsd through interpolation onto the mesh)

	pi=acos(-1.)
	fac=pi/180.
	do i=1,nn
	   u(i)=ampu(i)*cos(-fac*phaseu(i))
	   v(i)=ampv(i)*cos(-fac*phasev(i))
ccc           u(i)=0.0
ccc           v(i)=0.0
	   ah(i)=ampah(i)*cos(-fac*phaseah(i))
	end do
	
	iahchg=1
	return

	end if

	iahchg=0

	return
	end



