C*********************************************************************
C
C FUNDY4 FIXED SUBROUTINE WRITTEN BY PROFESSOR DANIEL R. LYNCH
C
      FUNCTION PHASELAGD(Z)
C
C COMPUTES THE NEGATIVE ARGUMENT OF A COMPLEX NUMBER Z, IN DEGREES.
C RESULT IS REPORTED IN THE RANGE 0. TO 360. 
C 
      COMPLEX Z
      PI=3.1415926535 
      FACTOR=180./PI
      PHASELAGD = 0.0
      IF(CABS(Z).GT.0.)  PHASELAGD = -FACTOR*ATAN2(AIMAG(Z), REAL(Z))
      IF(PHASELAGD.LT.0.) PHASELAGD = PHASELAGD + 360.  
      RETURN
      END
CC***********************************************************************
C***********************************************************************
      SUBROUTINE LOADVEL(nndim,nnvdim,nn,nnv,filename,zval,u,v,w)
C-----------------------------------------------------------------------
C purpose: This routine loads a .vel file
C
C index range: i=1,nn, j=1,nnv
C
C inputs:  nndim - parameter used to dimension node arrays in the
C            calling routine
C          nnvdim - parameter used to dimension the number of 
C            vertical nodes in the calling routine
C          nn - number of horizontal nodes for which data should 
C            exist
C          nnv - number of vertical nodes for which data should 
C            exist  =>  data should exist for nn*nnv nodes
C          filename - name of file to be read
C
C outputs: zval(i,j) - z coordinate at horizontal node i
C            and vertical node j           
C          u(i,j) - x-component of the vector at horizontal 
C            node i and vertical node j
C          v(i,j) - y-component of the vector at horizontal 
C            node i and vertical node j
C          w(i,j) - z-component of the vector at horizontal 
C            node i and vertical node j
C          freq - frequency in radians/sec
C 
C file format: See CEN 3/29/93 Memorandum
C
C history:  Written by Christopher E. Naimie
C           Dartmouth College
C           30 JULY 1992
C           Revised: 25 APRIL 1994
C-----------------------------------------------------------------------
C
C ARGUMENTS
      real zval(nndim,nnvdim)
      complex u(nndim,nnvdim),v(nndim,nnvdim),w(nndim,nnvdim)
      character*72 filename,header
C
C START OF EXECUTABLE CODE
C
C Open file
      open(63,file=filename,status='old')
C
C Read headers
      read(63,101)header
      read(63,101)header
      read(63,*)nnv
      read(63,101)header
      read(63,*)freq
C
C Check for oversize of arrays
      nflag=0
      if(nn.GT.nndim)then
         write(2,*)'Dimensioning problem in SUBROUTINE LOADVEL:'
         write(2,*)'  nn exceeds nndim => rectify and recompile'
         nflag=1
      endif
         if(nnv.GT.nnvdim)then
         write(2,*)'Dimensioning problem in SUBROUTINE LOADVEL:'
         write(2,*)'  nnv exceeds nnvdim => rectify and recompile'
         nflag=1
      endif
      if(nflag.EQ.1)stop
C
C Read data
      do 20 i=1,nndim
         do 10 j=1,nnv
            read(63,*,end=21)n,zval(i,j),uamp,upha,vamp,vpha,wamp,wpha 
            u(i,j)=CMPLX(uamp*COS(-upha),uamp*SIN(-upha))
            v(i,j)=CMPLX(vamp*COS(-vpha),vamp*SIN(-vpha))
            w(i,j)=CMPLX(wamp*COS(-wpha),wamp*SIN(-wpha))
            jj=j
 10      continue
         ii=i
 20   continue
 21   close(63)
C
C Message to standard out
      if(ii.NE.nn)then
         write(2,*)'There is a mismatch between the number of horizontal
     & nodes in your .vel file and nn in SUBROUTINE LOADVEL.'
         STOP
      else
         write(2,*)ii,'x',jj,' complex 3-D vector values loaded from ',
     &filename
      endif
C
C FORMAT STATEMENTS
 101  format(a)
C
C END OF ROUTINE
      return
      end

C***********************************************************************
C***********************************************************************
      SUBROUTINE LOADS2R(nndim,nn,filename,scval)
C-----------------------------------------------------------------------
C purpose: This routine loads a .s2r file
C
C index range: i=1,nn
C
C inputs:  nndim - parameter used to dimension node arrays in the
C            calling routine
C          nn - number of nodes for which data should exist
C          filename - name of file to be read
C
C outputs: scval(i) - real scalar value at node i
C 
C file format: See CEN 3/29/93 Memorandum
C
C history:  Written by Christopher E. Naimie
C           Dartmouth College
C           30 JULY 1992
C           Revised: 25 APRIL 1994
C-----------------------------------------------------------------------
C
C ARGUMENTS
      real scval(nndim)
      character*72 filename,header
C
C START OF EXECUTABLE CODE
C
C Open file
      open(63,file=filename,status='old')
C
C Read headers
      read(63,101)header
      read(63,101)header
C
C Check for oversize of arrays
      nflag=0
      if(nn.GT.nndim)then
	 write(2,*)'Dimensioning problem in SUBROUTINE LOADS2R:'
         write(2,*)'  nn exceeds nndim => rectify and recompile'
         nflag=1
      endif
      if(nflag.EQ.1)stop
C
C Read data
      do 10 i=1,nndim
         read(63,*,end=11)node,scval(node)
         ii=i
 10   continue
 11   close(63)
C
C Message to standard out
      if(ii.NE.nn)then
         write(2,*)'There is a mismatch between the number of horizontal
     & nodes in your .s2r file and nn in SUBROUTINE LOADS2R.'
         STOP
      else
         write(2,*)ii,' real 2-D scalar values loaded from ',filename
      endif
C
C FORMAT STATEMENTS
 101  format(a)
C
C END OF ROUTINE
      return
      end

C***********************************************************************
C*****************************************************************FUNDY5
C
      SUBROUTINE VERTAVGC(F,FBAR,Z,NN,NNV,NNDIM,NNVDIM)
      COMPLEX F(NNDIM,NNVDIM), FBAR(NNDIM)
      DIMENSION Z(NNDIM,NNVDIM)
C
C COMPUTES THE VERTICAL AVERAGE OF F, PUTS IT IN FBAR.
C DOES THIS FOR ALL HORIZONTAL NODES
C
      DO 100 I=1,NN
      FBAR(I)=(0.,0.)
      DO 200 J=2,NNV
      FBAR(I)=FBAR(I)+0.5*(F(I,J) + F(I,J-1))*(Z(I,J) - Z(I,J-1))
  200 CONTINUE
      FBAR(I)=FBAR(I)/(Z(I,NNV)-Z(I,1))
  100 CONTINUE
      RETURN
      END
C
