C***********************************************************************
C***********************************************************************
      SUBROUTINE LOADMESHGOM(nndim,nedim,pathmesh,x,y,in,bathy,nn,ne)
C-----------------------------------------------------------------------
C purpose: This routine loads LABLIB Standard node and element files for
C            a 2-D triangular finite element mesh
C
C index range: i=1,nn, k=1,ne
C
C inputs:  nndim - parameter for dimensioning the nodal coordinates
C          nedim - parameter for dimensioning the incidence list
C          pathmesh - the leading part of the path for the .nod, .ele,
C                       and .bat files.
C                  i.e.: g2s.nod, g2s.ele, and g2s.bat => pathmesh=g2s
C
C outputs: nn - number of nodes in the mesh
C          x(i),y(i) - nodal x and y coordinates for node i
C          bathy(i) - bathymetric depth for node i
C          ne - number of elements in the mesh
C          in(3,k) - LABLIB Standard incidence list for element j
C 
C file format: LABLIB Standard 2-D triangular linear element mesh
C              See CEN 3/29/93 Memorandum
C
C history:  Written by Christopher E. Naimie
C           Dartmouth College
C           22 APRIL 1992
C           Revised: 25 APRIL 1994
C           Revised: 25 FEBRUARY 1995
C-----------------------------------------------------------------------
C
C ARGUMENTS
      integer in(3,nedim)     
      dimension x(nndim),y(nndim),bathy(nndim)
      character*72 pathmesh
C
C START OF EXECUTABLE CODE
C
C Use cstring to find limits of pathmesh
      CALL CSTRING(pathmesh,lms,lme)
C
C open .nod, .ele, and .bat data files
      open(12,file=pathmesh(lms:lme)//'.nod',status='old')
      open(13,file=pathmesh(lms:lme)//'.bat',status='old')
      open(14,file=pathmesh(lms:lme)//'.ele',status='old')
C
C  Read node coordinates and the scalar value at each node from files
      do 5 i=1,nndim
        read(12,*,end=6)nn,x(i),y(i)
        read(13,*)nn,bathy(i)
 5    continue
         write(2,*)' Potential error reading .nod file =>',
     &             ' increase nndim such that it exceeds the number of',
     &             ' nodes by at least 1 and recompile.'
         stop
 6    continue
      write(2,*)nn, 'nodal coordinates read from ',
     &pathmesh(lms:lme),'.nod'
      write(2,*)nn, 'nodal bathymetries read from ',
     &pathmesh(lms:lme),'.bat'
      close(12)
      close(13)
C
C Read element data from file
      do 10 i=1,nedim
        read(14,*,end=11)ne,in(1,i),in(2,i),in(3,i)
 10   continue
         write(2,*)' Potential error reading .ele file =>',
     &             ' increase nedim such that it exceeds the number of',
     &             ' elements by at least 1 and recompile.'
         stop
 11   continue
      write(2,*)ne, 'elements read from ',pathmesh(lms:lme),'.ele'
      close(14)
C
C FORMAT STATEMENTS
 101  format(a)
C
C END OF ROUTINE
C
      return
      end
C*********************************************************************
C*********************************************************************
C
      SUBROUTINE SPRSBLD1(IN,NDIM,NNE,IQ,JQ,NN,NE,MN,NDF)
C
C  NOVEMBER 30, 1990
C  D.LYNCH REVISION OF K.PAULSEN REVISION OF WEIPING VERSION.
C  SIMPLE ADAPTATION OF SPRSBLDW1 BY REVERSING ORDER OF IN(,) ARGUMENTS.
C
C  BUILDS SPRSPAK ARRAYS IQ,JQ FROM ELEMENT INCIDENCE LIST IN(K,L)
C     WITH L=GLOBAL ELEMENT NUMBER, K=LOCAL NODE NUMBER
C     FOR NDF DEGREES OF FREEDOM AT EACH NODE -- i.e. 
C     NDF EQUATIONS AND NDF UNKNOWNS.
C     NDF IS THE SAME AT EACH NODE.
C
C  SAME AS SPRSBLDW1 EXCEPT FOR THE ORDER OF THE ARGUMENTS FOR THE IN ARRAY
C 
C  NDIM IS THE FIRST PHYSICAL DIMENSION OF IN; NDIM.GE.NNE
C  NNE INDICATES THAT IN(I,L) FOR I=1 THRU NNE ARE NODE NUMBERS; 
C     THE BALANCE (IF ANY) OF IN WILL BE IGNORED.  
C  IQ(I) IS THE ADDRESS IN QV OF THE LAST NONZERO ENTRY IN ROW I OF Q
C  JQ(K) IS THE COLUMN INDEX IN Q FOR QV(K)
C  NN IS THE ACTUAL NUMBER OF NODES
C  NE IS THE ACTUAL NUMBER OF ELEMENTS
C  MN EQUALS OR EXCEEDS THE MAXIMUM NUMBER OF NONZREO ENTRYS PER ROW, 
C     FOR A SCALAR (i.e. NDF=1) PROBLEM.
C  NDF IS THE DEGREES OF FREEDOM, ASSUMED THE SAME AT EACH NODE.
C
C  IT IS ASSUMED THAT IN MAIN PROGRAM, DIMENSIONS ARE AT LEAST 
C     IQ(NN*NDF), JQ((NN*NDF)*(MN*NDF)).  NOTE THAT JQ IS OVERSIZED; 
C     BUT THE ALGORITHM MAY USE THIS EXTRA SIZE.  
C
C  CALLS ARE MADE TO SPRSINSRTD AND SPRSBLD3DD
C
      DIMENSION IN(NDIM,1),IQ(1),JQ(1)
C
C  INITIALIZE JQ
C
       DO 5 I=1,NN*MN
       JQ(I)=0
    5 CONTINUE
C
C  INITIALIZE JQ AS DIAGONAL MATRIX
C
      DO 10 I=1,NN
      J=(I-1)*MN+1
      JQ(J)=I
   10 CONTINUE
C
C  ELEMENT LOOP FOR JQ, ASSUMING NDF=1.
C  ALL ROWS ALLOWED MN ENTRIES.
C  TRAILING ZEROS WILL BE REMOVED BELOW.
C
      DO 100 L=1,NE
      DO 90 I=1,NNE
      II=IN(I,L)
      DO 90 J=1,NNE
      JJ=IN(J,L)
      IF(I.NE.J) CALL SPRSINSRTD(II,JJ,JQ,MN)
   90 CONTINUE
  100 CONTINUE
C
C FIND IQ FROM JQ
C
       K=0
       KK=0
       DO 110 I=1,NN
       DO 120 J=1,MN
       KK=KK+1
       IF(JQ(KK).NE.0) K=K+1
  120 CONTINUE
       IQ(I)=K
  110 CONTINUE      
C
C REARRANGE (CONDENSE) THE JQ -- REMOVE THE TRAILING ZEROS
C
       DO 140 I=2,NN
        KMIN=IQ(I-1)+1
        KMAX=IQ(I)
        KJMIN=(I-1)*MN+1
        DO 130 K=KMIN,KMAX
          JQ(K)=JQ(KJMIN)
          KJMIN=KJMIN+1
  130 CONTINUE
  140 CONTINUE
C
C IQ, JQ NOW CORRECT FOR NDF=1
C EXPAND FOR NDF.GT.1
C
        IF (NDF.GT.1) THEN
	CALL SPRSBLD3DD(IQ,JQ,NN,NDF)
	ELSE
	 GO TO 200
        END IF
  200 RETURN
      END
C

C*********************************************************************
C*********************************************************************
C
      SUBROUTINE SPRSINVMLT(QV,IQ,D,NN)
C
C  REPLACES QV WITH INV(D)*QV
C  D IS A DIAGONAL MATRIX, LENGTH NN 
C  NN IS THE SIZE OF Q (# OF EQUATIONS)
C
      DIMENSION QV(1),D(1),IQ(1)
      KMAX=0
      DO 10 I=1,NN
      KMIN=KMAX+1
      KMAX=IQ(I)
      FTR=1./D(I)
      DO 20 K=KMIN,KMAX
   20 QV(K)=FTR*QV(K)
   10 CONTINUE
      RETURN
      END
C

C*********************************************************************
C*********************************************************************
C
      FUNCTION KAY(I,J,IQ,JQ)
C
C  FINDS ADDRESS K IN QV FOR Q(I,J)
C
      DIMENSION IQ(1),JQ(1)
      KAY=IQ(I)+1
   10 KAY=KAY-1
      IF(JQ(KAY).NE.J)GO TO 10
      RETURN
      END

C*********************************************************************
C
      SUBROUTINE SPRSMLTIS3(I,QV1,qv2,qv3,IQ,JQ,X,B1,b2,b3,
     &                      ntv,NNDIM,NtvDIM)
C
C  MULTIPLIES THE Ith ROW OF QV BY THE Jth COLUMN OF THE MATRIX X,
C     FOR ALL VALUES OF J FROM 1 TO NNV
C  ANSWER RETURNS IN THE VECTOR B
C     (OR: OBTAINS ONLY Bi OF Q*X=B)
C  IQ,JQ ARE THE STANDARD POINTERS FOR QV
C  NNDIM IS THE FIRST PHYSICAL DIMENSION OF X
C  THIS ROUTINE IS NONDESTRUCTIVE
C
      DIMENSION QV1(1),qv2(1),qv3(1)
      dimension IQ(1),JQ(1),X(NtvDIM,NNDIM)
      dimension B1(ntvdim),B2(ntvdim),B3(ntvdim)
      KMIN=1
      IF(I.GT.1) KMIN=IQ(I-1)+1
      KMAX=IQ(I)
		
      DO itv=1,ntv
      B1(itv)=0.
	b2(itv)=0.
	b3(itv)=0.
	end do

      DO 10 K=KMIN,KMAX
	qv1k=qv1(k)
	qv2k=qv2(k)
	qv3k=qv3(k)
	jqk=jq(k)
	do itv=1,ntv
	xij=X(itv,JQK)
      B1(itv)=B1(itv)+QV1K*Xij
      B2(itv)=B2(itv)+QV2K*Xij
      B3(itv)=B3(itv)+QV3K*Xij
	end do

   10 CONTINUE
      RETURN
      END
C  
C  
C
      SUBROUTINE GDAY(IDD,IMM,IYear,KD)
C!
C!  GIVEN DAY,MONTH,(EACH 2 DIGITS) and year (four digits), GDAY RETURNS
C!  THE DAY#, KD BASED ON THE GREGORIAN CALENDAR.
C!  THE GREGORIAN CALENDAR, CURRENTLY 'UNIVERSALLY' IN USE WAS
C!  INITIATED IN EUROPE IN THE SIXTEENTH CENTURY. NOTE THAT GDAY
C!  IS VALID ONLY FOR GREGORIAN CALENDAR DATES.
C
C   KD=1 CORRESPONDS TO JANUARY 1, 0000
C	
c 	Note that the Gregorian reform of the Julian calendar 
c	omitted 10 days in 1582 in order to restore the date
c	of the vernal equinox to March 21 (the day after
c	Oct 4, 1582 became Oct 15, 1582), and revised the leap 
c	year rule so that centurial years not divisible by 400
c	were not leap years.
c
C   THIS ROUTINE WAS WRITTEN BY EUGENE NEUFELD, AT IOS, IN JUNE 1990.
C
      INTEGER NDP(13)
      INTEGER NDM(12)
	
      DATA NDP/0,31,59,90,120,151,181,212,243,273,304,334,365/
      DATA NDM/31,28,31,30,31,30,31,31,30,31,30,31/
C!
	lp=2
c make iyy and icc variables
        icc=iyear/100
        iyy=iyear-icc*100

C!  TEST FOR INVALID INPUT:
      IF(ICC.LT.0)THEN
	 WRITE(LP,5000)ICC
	 STOP
      ENDIF
      IF(IYY.LT.0.OR.IYY.GT.99)THEN
	 WRITE(LP,5010)IYY
	 STOP
      ENDIF
      IF(IMM.LE.0.OR.IMM.GT.12)THEN
	 WRITE(LP,5020)IMM
	 STOP
      ENDIF
      IF(IDD.LE.0)THEN
	 WRITE(LP,5030)IDD
	 STOP
      ENDIF
      IF(IMM.NE.2.AND.IDD.GT.NDM(IMM))THEN
	 WRITE(LP,5030)IDD
	 STOP
      ENDIF
      IF(IMM.EQ.2.AND.IDD.GT.29)THEN
	 WRITE(LP,5030)IDD
	 STOP
      ENDIF
      IF(IMM.EQ.2.AND.IDD.GT.28.AND.((IYY/4)*4-IYY.NE.0.OR.(IYY.EQ.0.AND
     .    .(ICC/4)*4-ICC.NE.0)))THEN
	 WRITE(LP,5030)IDD
	 STOP
      ENDIF
5000  FORMAT(' INPUT ERROR. ICC = ',I7)
5010  FORMAT(' INPUT ERROR. IYY = ',I7)
5020  FORMAT(' INPUT ERROR. IMM = ',I7)
5030  FORMAT(' INPUT ERROR. IDD = ',I7)
C!
C!  CALCULATE DAY# OF LAST DAY OF LAST CENTURY:
      KD = ICC*36524 + (ICC+3)/4
C!
C!  CALCULATE DAY# OF LAST DAY OF LAST YEAR:
      KD = KD + IYY*365 + (IYY+3)/4
C!
C!  ADJUST FOR CENTURY RULE:
C!  (VIZ. NO LEAP-YEARS ON CENTURYS EXCEPT WHEN THE 2-DIGIT
C!  CENTURY IS DIVISIBLE BY 4.)
      IF(IYY.GT.0.AND.(ICC-(ICC/4)*4).NE.0) KD=KD-1
C!  KD NOW TRULY REPRESENTS THE DAY# OF THE LAST DAY OF LAST YEAR.
C!
C!  CALCULATE DAY# OF LAST DAY OF LAST MONTH:
      KD = KD + NDP(IMM)
C!
C!  ADJUST FOR LEAP YEARS:
      IF(IMM.GT.2.AND.((IYY/4)*4-IYY).EQ.0.AND.((IYY.NE.0).OR.
     .   (((ICC/4)*4-ICC).EQ.0)))   KD=KD+1
C!  KD NOW TRULY REPRESENTS THE DAY# OF THE LAST DAY OF THE LAST
C!  MONTH.
C!
C!  CALCULATE THE CURRENT DAY#:
      KD = KD + IDD
      RETURN
C!
C!
      ENTRY DMY(IDD,IMM,IYear,KD)
C!
C!  GIVEN THE (GREGORIAN) DAY#, KD, AS CALCULATED ABOVE IN THIS ROUTINE,
C!  ENTRY DMY RETURNS THE (GREGORIAN) DAY, MONTH, YEAR AND CENTURY.
C!
C!  TEST FOR VALID INPUT:
      IF(KD.LE.0) WRITE(LP,5040)KD
5040  FORMAT(' KD = ',I7,'  INVALID INPUT. DMY STOP.')
C!
C!  SAVE KD
      KKD=KD
C!  CALCULATE ICC AND SUBTRACT THE NUMBER OF DAYS REPRESENTED BY ICC
C!  FROM KKD
C!  JFH IS THE NUMBER OF 400 YEAR INTERVALS UP TO KKD
C!  JCC IS THE NUMBER OF ADDITIONAL CENTURIES UP TO KKD
      JFH = KKD/146097
      KKD = KKD - JFH*146097
      IF(KKD.LT.36525)THEN
	 JCC = 0
      ELSE
	 KKD = KKD - 36525
	 JCC = 1 + KKD/36524
	 KKD = KKD - (JCC-1)*36524
      END IF
      ICC = 4*JFH + JCC
      IF(KKD.EQ.0)THEN
	 ICC = ICC-1
	 IYY = 99
	 IMM = 12
	 IDD = 31
c	 RETURN
	go to 110
      ENDIF
C!
C!  CALCULATE IYY. JFY IS THE NUMBER OF FOUR YEAR INTERVALS IN THE
C!  CURRENT CENTURY. THE FIRST FOUR YEAR INTERVAL IS SHORT (1460 DAYS
C!  RATHER THAN 1461)IF THE CURRENT CENTURY IS NOT DIVISIBLE BY 4, AND
C!  IN THIS CASE JCC.NE.0 AS CALCULATED ABOVE.
C!
C!  CALCULATE JFY:
      JFY = 0
      IF(JCC.EQ.0)GOTO 10
      IF(KKD.LT.1460)GOTO 10
      JFY = 1
      KKD = KKD - 1460
10    KK = KKD/1461
      JFY = JFY + KK
      KKD = KKD - KK*1461
C!
C!  CALCULATE JYY, THE REMAINING YEARS OF THE CURRENT CENTURY UP TO THE
C!  CURRENT DAY:
      JYY = 0
C!  THE NEXT YEAR IS NOT A LEAP YEAR IF JFY=0 AND JCC.NE.0.
      IF(JFY.EQ.0.AND.JCC.NE.0)GOTO 20
      IF(KKD.LT.366)GOTO 30
      JYY = 1
      KKD = KKD - 366
20    JYYY = KKD/365
      JYY = JYY + JYYY
      KKD = KKD - JYYY*365
30    IYY = 4*JFY + JYY
      IF(KKD.EQ.0) THEN
	 IYY=IYY-1
	 IMM=12
	 IDD=31
c	 RETURN
	go to 110
      END IF
C!
C!  SET L=1 IF WE HAVE A LEAP YEAR.
      L=0
      IF(IYY-(IYY/4)*4.NE.0)GOTO 40
      IF(IYY.EQ.0.AND.(ICC-(ICC/4)*4).NE.0)GOTO 40
      L=1
C!
C!  CALCULATE IMM AND IDD
40    IF(KKD.GT.31) GOTO 50
      IMM=1
      IDD=KKD
c      RETURN
       go to 110
C!
50    IF(KKD.GT.59)GOTO 60
      IMM = 2
      IDD = KKD-31
c      RETURN
	go to 110
C!
60    IF(KKD.GT.60)GOTO 70
      IF(L.EQ.0)GOTO 70
      IMM = 2
      IDD = 29
c      RETURN
	go to 110
C!
70    IF(L.EQ.1) KKD=KKD-1
      DO 80 I=4,13
	 IF(KKD.GT.NDP(I))GOTO 80
	 IMM = I-1
	 IDD = KKD - NDP(I-1)
c	 RETURN
	go to 110
C!
80    CONTINUE

 110 	iyear=icc*100+iyy
	return

90    WRITE(LP,5050)
5050  FORMAT(' ERROR IN DMY.')
      STOP
      END

	Subroutine Up_date(kd,ssec)
C 
C this subroutine updates the current gregorian day number kd
C and resets the time, ssec, accordingly
C it inherently assumes that the variable is updated every day!

      integer kd
      real ssec
	
      kd=kd+aint(ssec/8.64E4)
      ssec=amod(ssec,8.64E4)
 
      return
      end
C --------------------------------------------------------------------
	SUBROUTINE READ_INPUT(filinp,casnam,ntv,DEG,
     &              DELT,kd0,ssec0,kdq,ssecq)
	include 'ACADIA.DIM'
C
C This subroutine reads in an ACADIA.inp file
C
C Global Variables
	Character*72 casnam, filinp
	REAL deg, delt, ssec0, ssecq
	integer idd0, imm0, iyear0, ntv
	integer iddq, immq, iyearq

C Local Variables
      CHARACTER*72 CHACT1, COMINP, LLABEL, filecho
	integer indx

	filecho='ACADIA.echo'

      OPEN (UNIT=1, FILE=FILINP, STATUS='OLD')
	open (unit=2, file=filecho)

	write(2,*) '****************************************************'
	write(2,*) '               ACADIA ECHO FILE'
	write(2,*) '****************************************************'
	write(2,*) ' '

      READ (1,600) LLABEL
      READ (1,600) COMINP
	write(2,*) cominp
      READ (1,600) LLABEL
      READ (1,600) CHACT1
      ICAS = INDEX(CHACT1,' ') - 1
      CASNAM = CHACT1(1:ICAS)
	write(2,*) 'for mesh ', casnam
      READ (1,600) LLABEL
      READ (1,*) ntv
	if (ntv.gt.ntvdim) then
	  write(2,*) 'error in ntvdim, plesae increase and recompile'
	  stop
	end if
	write(2,*) 'number of transport variables ',ntv
      READ (1,*) DEG
	write(2,*) 'degrees lattitude of center of mesh ', deg
      READ (1,*) DELT
	write(2,*) 'time step in seconds ',delt
	read (1,*) idd0,imm0,iyear0,ssec0
	read (1,*) iddq,immq,iyearq,ssecq

	call gday(idd0,imm0,iyear0,kd0)
      if (ssec.ge.8.64E4) call up_date (kd0,ssec0)

	call gday(iddq,immq,iyearq,kdq)
      if (ssecq.ge.8.64E4) call up_date (kdq,ssecq)

	write(2,*) 'simulation beginning on',IDD0,IMM0,IYEAR0,SSEC0 
	write(2,*) 'gregorian day and time', kd0,ssec0
	write(2,*) 'simulation ending on',IDDQ,IMMQ,IYEARQ,SSECQ
	write(2,*) 'gregorian day and time', kdq, ssecq

      CLOSE (1)
	
 600  format (a)

	RETURN
	END
C****67***************************************************************72
C***********************************************************************
      SUBROUTINE CSTRING(string,istart,iend)
C-----------------------------------------------------------------------
C purpose: This subroutine finds the first nonblank space (istart) in a 
C            arbitrary character string and the first subsequent blank
C            space (iend).  The range of string between istart and iend
C            can then be separated from the rest of string by specifying
C            string(istart:iend)
C
C
C inputs:  string - a character string of length .LE. 72
C
C outputs: istart - first nonblank character in string
C          iend   - first blank character in string after istart
C
C history:  Written by Christopher E. Naimie
C           Dartmouth College
C           12 JUNE 1992
C-----------------------------------------------------------------------
C
C ARGUMENTS
      character*72 string
C
C START OF EXECUTABLE CODE
C
C find beginning of string
      do 10 i=1,72
         istart=i
	 if(string(i:i).NE.' ')go to 11
 10   continue
C
C find end of string
 11   do 20 i=istart,72
         iend=i-1
	 if(string(i:i).EQ.' ')go to 21
 20   continue
C
C END OF ROUTINE
 21   return
      end
C***********************************************************************
C***********************************************************************
C*********************************************************************
C*********************************************************************
C
       SUBROUTINE SPRSBLD3DD(IQ,JQ,NN,NDF)
C
C BUILD 3D IDEX IQQ AND JQQ
C
       DIMENSION IQ(1),JQ(1)
	DO 60 I=NN,1,-1
	 IF (I.NE.1) THEN
	  II=IQ(I)-IQ(I-1)
	 ELSE
	  II=IQ(I)
	 END IF
	 DO 10 J=NDF,1,-1
	  IQ(NDF*(I-1)+J)=IQ(I)*NDF*NDF-(NDF-J)*NDF*II
   10	 CONTINUE
	 DO 30 K=1,II
	   JK=IQ(NDF*I)+1-(K-1)*NDF
	   IF (I.NE.1) THEN
	    JJ=JQ(IQ(I)-K+1)*NDF+1
	   ELSE
	    JJ=JQ(IQ(I)/NDF-K+1)*NDF+1
	   END IF
	  DO 20 J=1,NDF
	   JK=JK-1
	   JJ=JJ-1
C
C THE FOLLOWING 3 LINES FROM WEIPING'S CODE
C	   JQ(JK)=JJ
C	   JQ(JK-NDF*II)=JJ
C	   IF(NDF.EQ.3)	   JQ(JK-6*II)=JJ
C WORKED FOR NDF=2 OR 3.  REPLACED BY INDUCTION  
C WITH THE DO 15 LOOP BELOW (DRL 1 DECEMBER 1990).   
C IT IS NOT OBVIOUS THAT JQ REMAINS UNCORRUPTED IN THE 
C OVERWRITING.  
C
           DO 15 L=1,NDF
           JQ(JK-(L-1)*NDF*II)=JJ
   15      CONTINUE
   20	  CONTINUE
   30	 CONTINUE
   60	CONTINUE
        RETURN
        END
C
C*********************************************************************
C*********************************************************************
C
      SUBROUTINE SPRSINSRTD(I,J,JQ,MN)
C
C  INSERTS GLOBAL ADDRESS (I,J) INTO JQ(), 
C  ASSUMING EXACTLY MN ENTRIES IN EACH ROW.
C
      DIMENSION JQ(1)
      KMIN=(I-1)*MN+1
      KMAX=I*MN
C
C  SEARCH FOR INSERTION POINT KK
C
      DO 10 K=KMIN,KMAX
      KK=K
      IF(J.LT.JQ(K)) GO TO 20
      IF(J.EQ.JQ(K)) GO TO 50
      IF(JQ(K).EQ.0) GO TO 20
   10 CONTINUE
C
C  INSERT J AT JQ(KK); BUMP JQ
C
C CHECK INSERTED BY K PAULSEN 11/29...NOT VALIDATED AT TIME OF
C INSERTION !!!!
C
   20 IF(JQ(KMAX).NE.0) THEN
       WRITE(2,*) 'MAX CONNECTIVITY MN=',MN,
     *  'VIOLATED AT I,J=',I,J,'IN SPRSINSRTD'
       STOP
      END IF
      DO 30 K=KMAX-1,KK,-1
   30 JQ(K+1)=JQ(K)
      JQ(KK)=J   
C
C  DONE
C
   50 CONTINUE
      RETURN     
      END
C

C***********************************************************************
C***********************************************************************
C
C    Subroutine: INTTOCHR (INTG, FILPFX, IPOS)
C   Description: This subroutine converts integer INTG (maximum of I20)
C                to character string FILPFX(1:IPOS) (maximum of 20
C                characters).
C     Variables: [Argument list]
C                INTG -- Integer (maximum I20) to be converted
C                FILPFX -- Character string of maximum 20 characters
C                        converted from integer INTG
C                IPOS -- Position of the last meaningful (non-blank)
C                        character in FILPFX
C                [Local integer variables]
C                CBLANK -- The blank space character
C                I -- Do loop index
C                INDX -- Position of the first blank space at the tail
C                        of FILPFX before editting out the blanks
C                LMAX -- Maximum number of characters allowed in the
C                        converted character string
C         Input: INTG
C        Output: FILPFX, IPOS
C
C***********************************************************************
C23456789012345678901234567890123456789012345678901234567890123456789012
C________1_________2_________3_________4_________5_________6_________7_|
C
C...Argument list of the subroutine
C
      SUBROUTINE INTTOCHR (INTG, FILPFX, IPOS)
C
C...Declare no implicit variable type
C
      IMPLICIT NONE
C
C...Variable declaration of the argument list
C
      CHARACTER*20 FILPFX
      INTEGER INTG, IPOS
C
C...Declaration of the local variables
C
      CHARACTER*1 CBLANK
C###      INTEGER I, INDX
      INTEGER I, LMAX
C
C...Define the maximum length of the character string
C
      LMAX = 20
C
C...Define a blank space character
C
      CBLANK = ' '
C
C...Convert an I20 integer INTG to a CHARACTER*72 string FILPFX using
C   interal write statement
C
      WRITE (FILPFX,'(I20)') INTG
C
C...Edit out all the blank spaces from the beginning of FILPFX and
C   reload the meaningful string back as FILPFX(1:IPOS), where IPOS
C   is the position of the last meaningful (non-blank) character in
C   FILPFX
C
      DO 10 I=1,LMAX
         IF (FILPFX(I:I) .NE. CBLANK) GOTO 20
   10 CONTINUE
      WRITE (2,*) 'Invalid file prefix for output files'
      STOP 1111
   20 CONTINUE
      IPOS = LMAX - I + 1
      FILPFX = FILPFX(I:LMAX)
C
C...Delete the tailing blanks of the string
C
C###      IPOS = INDEX(FILPFX(I:72),CBLANK)
C###      INDX = IPOS + I - 1
C###      FILPFX = FILPFX(I:INDX-1)
C###      IPOS = IPOS - 1
C
C...Terminate subroutine INTTOCHR and return to the calling program
C
      RETURN
      END


	subroutine sparsestor(nn,ne,in,x,y,iter,bathy,ah,
     &                      iq,jq,sv,ppx,ppy,agpgp)
	include 'ACADIA.DIM'
      INTEGER IN(3,NEDIM)
	integer nftr, nn, ne, iter, dtype
	real x(nndim), y(nndim)
	real DX(3,NEDIM),DY(3,NEDIM), AR(NEDIM)
      INTEGER IQ(NNDIM), JQ(NFTRDIM*NNDIM)
      REAL PPX(NFTRDIM*NNDIM), PPY(NFTRDIM*NNDIM), sv(nndim)
      REAL AGPGP(NFTRDIM*NNDIM)
	real ah(nndim), bathy(nndim),dhav(nedim)
	real svh(nndim)

	save dx, dy, ar, nftr, svh

	if (iter.ne.0) go to 100

C initalize and assemble PPX and PPY
	do i=1,nn
	sv(i)=0.
	end do

      DO 30 I=1,NFTRDIM*NNDIM
      PPX(I)  = 0.0
      PPY(I)  = 0.0
 30   CONTINUE      

C  SPRSBLD1 is used instead of SPRSBLD for efficiency (7.8.93)

      CALL SPRSBLD1 (IN, 3, 3, IQ, JQ, NN, NE, NFTRDIM, 1)
      WRITE (2,*) 'Subroutine SPRSBLD1 executed'
C
      NFTR=IQ(NN)/NN +1
      IF(NFTR.GT.NFTRDIM)THEN
      write(2,*) 'NFTR, NFTRDIM=',NFTR,NFTRDIM,';EXECUTION TERMINATED'
      STOP 
      END IF

C  COMPUTE ELEMENT AREAS, DELX, DELY
C                
      DO 40 L=1,NE       
      I1=IN(1,L)          
      I2=IN(2,L)          
      I3=IN(3,L) 
      DX(1,L)=X(I2)-X(I3)          
      DX(2,L)=X(I3)-X(I1)          
      DX(3,L)=X(I1)-X(I2)          
      DY(1,L)=Y(I2)-Y(I3)          
      DY(2,L)=Y(I3)-Y(I1)          
      DY(3,L)=Y(I1)-Y(I2)          
      AR(L) = 0.5*(X(I1)*DY(1,L)+X(I2)*DY(2,L)+X(I3)*DY(3,L))   
      IF(AR(L).LE.0.0) WRITE(2,*) ' NEGATIVE AREA IN ELEMENT', L 
  40  CONTINUE
C                
C  COMPUTE DIAGONAL MASS MATRIX SV(I);
C  BANDED DEPTH MATRIX SH(J,i) (transposed)
C  AND DERIVATIVE MATRICES IN SPRSPAK FORM:
C     PPX = <Pi*dP/dxj>
C     PPY = <Pi*dP/dyj>

      DO 50 L=1,NE       
      ARR=AR(L)       
      DO 60 I=1,3        
      II=IN(I,L)          
      SV(II)=SV(II)+ARR/3.0
      DO 70 J=1,3
      IJ=IN(J,L)
      K=KAY(II,IJ,IQ,JQ)
      PPX(K)=PPX(K)+DY(J,L)/6.   
	PPY(K)=PPY(K)-DX(J,L)/6. 

  70  CONTINUE
  60  CONTINUE
  50  CONTINUE

C
C  PREMULTIPLY PPX AND PPY BY INVERSE OF SV
C
      CALL SPRSINVMLT (PPX, IQ, SV, NN)
      CALL SPRSINVMLT (PPY, IQ, SV, NN)

	do i=1,nn
	svh(i)=sv(i)*bathy(i)
	end do

 100   Continue

C Compute Laplacian

C Laplacian matrix 
C     AGPGP = -<AH*grad(phi_i) . grad(phi_j)>
C
      DO 156 I=1,NFTR*NN
      AGPGP(I)= 0.0
  156 CONTINUE         
	do l=1,ne
       I1=IN(1,L)          
       I2=IN(2,L)          
       I3=IN(3,L) 
   	    dhav(l)=(ah(i1)*bathy(i1)+
     &         ah(i2)*bathy(i2)+ah(i3)*bathy(i3))/3.   
	end do

      DO L=1,NE       
      ARR=AR(L) 
	do i=1,3
      II=IN(I,L)
      DO J=1,3
      IJ=IN(J,L)
      K=KAY(II,IJ,IQ,JQ)
      AGPGP(K) = AGPGP(K) - dhav(l)*(DX(J,L)*DX(I,L)
     &                             + DY(J,L)*DY(I,L))/4./ARR

	end do
	end do
      end do

      CALL SPRSINVMLT (AGPGP, IQ, SVH, NN)         

      RETURN
      END
