C   acadia_bio.f 
C last updated 08/21/02
C ***********************************************************************
      SUBROUTINE INITCYST(mq,dt,cystbed,cystinit,gd)

C This subroutine is called once per simulation during the initialization 
C stage of the core program. The purpose is to define compensation depth,
C time cysts need to get that depth (time is in sec), and depth level 
C nearest to bottom ( for temperature and salinity fields).

      INCLUDE 'cyst.inc' 

      integer mq
      real WMIG,G_EFF,GRAZE,GMAX,GR,AKSN,attenk,xx
      real DGERM,DASWR_AVG
      real dt(mq),cystbed(mq),cystinit(mq),gd(mq)
      character*72 header

      WMIG=10.0
      WMIG=WMIG/(24.0*60.0*60.0)

      G_EFF = 0.017     ! growth efficiency 
      GR = 0.05         ! maintenance growth
      AKSN = 1.5        ! DIN half-sat
      attenk =- 0.20    ! light attenuation

       DGERM = 1.0 
C      DGERM = 0.5 
C      DGERM = 3.0 

        DASWR_AVG = 345.5
        C_DEPTH = 1/ATTENK*LOG(GR/(G_EFF*DASWR_AVG))
        write(2,*) 'daswr_avg & compensation depth'
        write(2,*) daswr_avg,C_DEPTH
C read cyst and shortwave radiation flux data
        write(2,*) 'opening cyst.dat file'
       open(unit=24, file='cyst_ch5.s2r',status='old')

      DO 10 N = 1,MQ
	READ(24,*) I, CYSTBED(I)
         DASWR(I) = 280
   10  CONTINUE
	close(24)

        write(2,*) 'complete reading cyst.dat file '
C set up the temperature and salinity fields
        write(2,*) 'opening T&S files for March-April'
	open(unit=15,
     & file='/usr/people/valery/acadia/g2s_5b/ma_te_g2s_5b.dat',
     & status='old')
	open(unit=16,
     & file='/usr/people/valery/acadia/g2s_5b/ma_sa_g2s_5b.dat',
     & status='old')

        read(15,101)header
        read(15,101)header
        read(15,*) xx
        write(2,*) xx

        read(16,101)header
        read(16,101)header
        read(16,*) xx
        write(2,*) xx

        read(15,*) (HTS(I),i=1,KS)
        read(16,*) (HTS(I),i=1,KS)

	do 15 j=1,mq
        read(15,*) (T(I,j),I=1,KS)        
        read(16,*) (S(I,j),I=1,KS)
 15      continue
	
	close(15)
        close(16)
        write(2,*) 'complete reading T&S files for March-April'

        write(2,*) (hts(i),i=1,KS)

        DO 12 I = 1,MQ
        IF (CYSTBED(I).NE.-99) THEN
        CYSTINIT(I) = CYSTBED(I)*10000*DGERM        
        GD(I)=0.0
        ELSE
        CYSTINIT(I) = 0.0
        GD(I)=-99
        END IF
        CYSTBED(I) = CYSTINIT(I)

        GB(I)=-9
        DO 9 K = 1,KS-1
        A1=DT(I)-abs(HTS(K))
        A2=DT(I)-abs(HTS(K+1))
        IF (A1.GE.0) THEN
        GB(I)=1
        GOTO 12
        ELSE
        IF ((A1.LT.0).AND.(A2.GT.0)) THEN
        GB(I)=K+1
        GOTO 12
        END IF
        END IF
   9  CONTINUE
        if(gb(I).eq.-9) gb(I)=ks-1
  12  CONTINUE  
        write(2,*) 'GB - depth initialization completed'
        write(2,*) 'complete cyst initialization '
C
C FORMAT STATEMENTS
 101  format(a)

       RETURN
        END

C
C ***************************************************************************

      SUBROUTINE CELLFLUX(mq,yearday,dt,delt,gd,cystinit,cystbed,
     & cellflx,cellflxb,ccellflx,pgerm,kter)

      INCLUDE 'cyst.inc'

C This subroutine calculates the amount of germinating cells based on spatial
C cyst bed data and on equations relating cyst germination rates to light and
C temperature.  It adds the germinated cells to the pre-existing cell levels.
C See http://www.whoi.edu/science/AOPE/people/cstock/ecohab/biology.html for
C details.

C NOTE:
C before entering this routine the CYSTBED and CYSTINIT need to be filled in.
C these arrays should be the horizontal dimension of the model grid (IM,JM) and hold the
C # of cysts/m^2 in the top 1 cm of sediment over the grid cell.  CYSTINIT is used to 
C store the initial concentration of cysts in a grid cell, while CYSTBED is used to track
C the evolution of the cyst concentration over time.  I form these in a seperate routine
C by reading in input from a text file and pass them to this routine through 'dino.inc'.
C Other variables in this routine passed through dino.inc are CELLFLX(IM,JM),
C CCELLFLX(IM,JM), PGERM(IM,JM), and CELLFLXB(IM,JM).

C GERML = germination rate under light conditions at i,j
C GERMD = germination rate under dark conditions at i,j
C GERM = germination rate at grid cell i,j
C EFLUX is used to account for light attenuation within the sediment
C if desired. 
       integer mq,YEARDAY,kter,pp
       real GERML, GERMD,GERM,EFLUX(10),delt,xx
       real DT(mq),gd(mq),cellflx(mq),cellflxb(mq),
     & ccellflx(mq),pgerm(mq),cystbed(mq),cystinit(mq)
       character*72 header
C setting light attenuation constant in the water (ATTENK) and the 
C sediment (ATTENS) along with the light values which differentiate the
C "light", "dark", and "transitional" flux zones (see web page).
C DGERM is the depth of cysts that contribute to blooms over a given
C spring.  By default, it is set to a value of 1 cm.  
      pp=0                      ! switcher=0/1
      ATTENK = -0.20            ! m-1
      ATTENS = -30.0            ! cm-1
      EFLUXL = 2.4              ! watts/m^2
      EFLUXD = 0.024            ! watts/m^2
      DGERM = 1.0               ! 

        if  (kter.eq.(288*61+1)) then
C set up the temperature and salinity fields
        write(2,*) 'opening T&S files for May_June'
	open(unit=15,
     & file='/usr/people/valery/acadia/g2s_5b/mj_te_g2s_5b.dat',
     & status='old')
	open(unit=16,
     & file='/usr/people/valery/acadia/g2s_5b/mj_sa_g2s_5b.dat',
     & status='old')
        pp=1
        else
        if  (kter.eq.(288*122+1)) then
C set up the temperature and salinity fields
        write(2,*) 'opening T&S files for July_August'
	open(unit=15,
     & file='/usr/people/valery/acadia/g2s_5b/ja_te_g2s_5b.dat',
     & status='old')
	open(unit=16,
     & file='/usr/people/valery/acadia/g2s_5b/ja_sa_g2s_5b.dat',
     & status='old')
       pp=1
        end if
        end if

        if(pp.eq.1) then
 
        read(15,101) header
        read(15,101) header
        read(15,*) xx
        write(2,*) xx

        read(16,101) header
        read(16,101) header
        read(16,*) xx
        write(2,*) xx

        read(15,*) (HTS(I),i=1,KS)
        read(16,*) (HTS(I),i=1,KS)

	do 15 j=1,mq
        read(15,*) (T(I,j),I=1,KS)        
        read(16,*) (S(I,j),I=1,KS)
 15      continue
	
	close(15)
        close(16)
        if  (kter.eq.(288*61+1)) then
        write(2,*) 'complete reading T&S files for May-June ' 
        else
        write(2,*) 'complete reading T&S files for July-August '
        endif

c        write(2,*) (hts(i),i=1,KS)
c        open(unit=44,file='mj_ts_d.dat',status='new')
c        do j=1,mq
c        write(44,'(i5,3E12.4)')GB(j),HTS(GB(j)),T(GB(j),j),S(GB(j),j)
c        end do
c        close(44)
      
        end if
      
C account for the endogenous clock, ENDOSCALE is a normalized factor which
C scales the germination rate directly

      IF (YEARDAY.LE.41.OR.YEARDAY.GT.327) THEN
        ENDOSCALE = 0.0
      ELSE IF (YEARDAY.GT.41.AND.YEARDAY.LE.88) THEN
        ENDOSCALE = (0.0202*YEARDAY - 0.83)/0.972
      ELSE IF (YEARDAY.GT.88.AND.YEARDAY.LE.179) THEN
        ENDOSCALE = 1.0
      ELSE
        ENDOSCALE = (-0.0066*YEARDAY + 2.14)/0.972
      END IF
c         write(2,'(i3,E15.6)') yearday, endoscale      
      DO 30 I = 1,MQ

        IF (GD(I).NE.-99) THEN
 
C calculate germination rate under light and dark conditions from Amy/Bruce's data
C % cysts/day.  Temperature in the bottom grid cell at each i,j
          TT=T(GB(I),I)
          GERML = 0.6578*TT - 0.8395
          GERMD = 0.1047*TT + 0.4862

C enforce minimum/maximum values for light and dark conditions
  
        IF (GERML.LT.0.9277) THEN
          GERML = 0.9277
          ELSE IF (GERML.GT.7.2047) THEN
            GERML = 7.2047
          ELSE IF (GERMD.LT.0.8130) THEN
            GERMD = 0.8130
          ELSE IF (GERMD.GT.1.7910) THEN
            GERMD = 1.7910
          END IF

C calculate the bottom energy flux based on the observed short-wave radiation
C at the sea surface - DASWR = day-light averaged (6 AM - 8 PM) short wave
C radiation (watts/m^2).  The code can represent a "well-mixed" sediment column
C by setting ATTENS = 0, or a static sediment column calculating rate as it varies
C through the top DGERM cm and integrating the flux.  The integration is done 
C roughly:
C               1. the top DGERM cm is divided into 10 vertical sub-sections
C               2. the light level in each section is calculated using the combined
C                  water and sediment attenuation.
C               3. The germination rate in each sub-section is calculated and the
C                  arithmetic average is calculated to determine the flux of new
C                  cells from the sediment.
C
C Note that cyst distributions are assumed uniform over the top DGERM cm

C Variables:
C CELLFLX = the flux of new cells from the sediment
C CELLFLXB = CELLFLX from the previous time step
C DT = the water depth
C K = the subsection of sediment

        CELLFLXB(I) = CELLFLX(I) 
        germ=0.0

        DO 32 K = 1,10
            EFLUX(K)=(DASWR(I)*EXP(ATTENK*DT(I)))
     &                 *EXP(ATTENS*(DGERM/10.*K - DGERM/20.))

C checking to see which light regime you are in in each sub-section and 
C calculating the germination rate.

          IF (EFLUX(K).GT.EFLUXL) THEN
              GERM = GERM+GERML*1/10
            ELSE IF (EFLUX(K).LT.EFLUXD) THEN
              GERM = GERM+GERMD*1/10
          ELSE
              GERM=GERM+((GERML-GERMD)*
     &        ((EFLUX(K)-EFLUXD)/(EFLUXL-EFLUXD))+
     &         GERMD)*1/10
            END IF

 32     CONTINUE

C adjusting the germination rate (in % day averaged over the top DGERM cm)
C to account for the endogenous clock

          GERM = GERM*ENDOSCALE

C convert % cysts/day into decimal fraction of cysts per time step (DTI in seconds)

          GERM = (GERM/100.0)*DELT/86400.0

C calculate the flux of cells away from the bottom in 1 time step.  This value
C is what is entered as the "source".  I entered it in the tracer advection routine,
C but anywhere that it can be used to augment the tracer (i.e. alexandrium conc. will
C work. Also track the cumulative cell flux (CCELLFLX)

          CELLFLX(I) = CYSTINIT(I)*GERM
          CCELLFLX(I) = CCELLFLX(I) + CELLFLX(I)

C calculate the number of cysts remaining after that flux away in the
C top 1 cm of sediment
          
        IF ((CYSTBED(I) - CELLFLX(I)).GT.0) THEN
            CYSTBED(I) = CYSTBED(I) - CELLFLX(I)
          ELSE 
            CELLFLX(I) = CYSTBED(I)
            CYSTBED(I) = 0 
          END IF 
         
c         if (DT(I).GT.C_DEPTH) then
c         CELLFLX(I) =CELLFLX(I) /C_DEPTH
c         else
           CELLFLX(I) =CELLFLX(I) /DT(I)
c         end if

C calculate the percent germination for display/analysis reasons

        IF (CYSTINIT(I).NE.0.0) THEN
          PGERM(I) = 100 - ((CYSTBED(I)/CYSTINIT(I)) * 100)
        ELSE
          PGERM(I) = 100.0
          END IF
          
       END IF

  30  CONTINUE
C
C FORMAT STATEMENTS
 101  format(a)

      RETURN
      END


C **********************************************************************
C **********************************************************************
      Subroutine DINOGROW(mq,dt,cw)
C
      Include 'cyst.inc'
C
C-----------------------------------------------------------------------
C         THIS FUNCTION SOLVES THE EQUATION DC/DT=+KC WHERE K IS
C         A Growth CONSTANT IN INVERSE SECONDS. The growth constant
c         is an empirical function of temperature, salinity and
c         depth (light) and was developed by Peter Franks
c         franks@ucsd.edu - modified by c. stock - see growth summary
c         dated 11/7/01.
C-----------------------------------------------------------------------
C      

        integer mq,swit
        real dt(mq),cw(mq)
        real z,sz,TTT,SSS

       G_EFF = 0.017     ! growth efficiency 
       GRAZE = 0.1       ! spatially constant grazing/mortality
       GMAX = 0.60       ! maximum growth rate
       GR = 0.05         ! maintenance growth
       AKSN = 1.5        ! DIN half-sat
       attenk =- 0.20    ! light attenuation
       swit=1
       sz=0.0
        do 10 I = 1,MQ
           
              TTT=T(KS,I)
              SSS=S(KS,I)
 
        T_FAC=-0.000347*TTT**3+0.0097*TTT**2-0.0133*TTT+0.131
        S_FAC=-0.0022*SSS**2+0.103*SSS-0.195
        G_FAC = S_FAC*T_FAC
c       IF(SWIT.EQ.1)then 
c         z=-144.8-0.38*TTT+4.75*SSS
c         DIN_OBS(I)=MAX(sz,z) 
c       end if
       IF(SWIT.EQ.1)then
        z=712.6+8.87*TTT-49.63*SSS+0.862*SSS*SSS-0.288*TTT*SSS
        DIN_OBS(I)=MAX(sz,z) 
       end if
      
C assume that deep newly germinated cells can get up to the 
C average compensation depth without losses.

        IF (DT(I).LT.C_DEPTH) THEN
        RAD = DASWR(I)/DT(I)*(1-exp(ATTENK*DT(I)))
        ELSE
        RAD = DASWR(I)/C_DEPTH*(1-exp(ATTENK*C_DEPTH))
        END IF 
        G_LIGHT = (GMAX*G_FAC+GR)*
     &  TANH(G_EFF*RAD/(GMAX*G_FAC+GR)) - GR
              

C DIN = the concentration of dissolved inorganic nitrogen.  below
C 20 meters it is assumed to be non-limiting (achieved by setting DIN=100)
C above, is based on interpolation of observations

c                IF ((DT(I)).LT.20) THEN
                  DIN = DIN_OBS(I)
c                ELSE
c                  DIN = 100
c                END IF

                G_DIN = GMAX*G_FAC*DIN/(AKSN+DIN)  

C GROWTH IS EITHER DIN OR LIGHT LIMITED
           IF(SWIT.EQ.0) THEN
                 RATE = G_LIGHT
           ELSE     
                 RATE = MIN(G_LIGHT, G_DIN)
           END IF

C APPLY LOSS TERMS (ONLY IF THEY ARE ABOVE CRITICAL DEPTH)

                RATE = RATE - GRAZE

                GROWTHFAC=RATE/(3600*24)
                CW(I) = GROWTHFAC

  10   Continue

c        open(unit=44,file='ma_ts_n.dat',status='new')
c        do i=1,mq
c        write(44,'(4E12.4)')T(KS,i),S(KS,i),DIN_OBS(I),DIN_OBS5(I)
c        end do
c        close(44)

        RETURN
        End 


