C
      PROGRAM ACADIA
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C    
C   Version 4.0 
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C 
C   Time-Domain Solution of 2-D Nonlinear 
C   Advection-Diffusion-Reaction Equations
C
C   Diagnostic specification of Velocity Field
C 
C   Linear Finite Elements:
C     Unstructured Linear Triangles in (x,y)
C     I is horizontal (X,Y) node number
C
C   Arrays and Constants:
C   Horizontal Positional Arrays (X,Y) are dimensioned either by 
C      horizontal node number (I) or horizontal element number (L). 
C   Concentration Arrays are dimensioned by individual transport 
C      variables (m) and horizontal node number node number (i).
C      m=1 to ntv
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C                
C     PARAMETERS:
C
C        NNDIM   .GTE. NN            
C        NEDIM   .GTE. NE 
C        NFTRDIM .GTE. NFTR  
C	 NTVDIM.GTE.NTV
C        
C        NN IS THE NUMBER OF NODES          
C        NE IS THE NUMBER OF ELEMENTS 
C        NFTR IS THE SPARSE MATRIX FACTOR:    NFTR=IQ(NN)/NN +1   
C	 NTV IS THE NUMBER OF TRANSPORT VARIABLES
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C     C(M,I) IS THE CONCENTRATION OF THE M'TH TRANSPORT VARIABLE
C            AT NODE I AND TIME T
C     RC(M,I) IS THE P'TH TRANSPORT VARIABLE REACTION TERM AT 
C            NODE I AND TIME T
C     M GOES FROM 1 TO NTV
C     SV(I) IS THE MASS MATRIX
C     IN IS THE ELEMENT INCIDENCE LIST
C     AR(L) IS THE AREA OF ELEMENT L
C     X(I),Y(I) ARE THE X AND Y COORDINATES OF NODE I
C     X IS POSITIVE EASTWARD; Y IS POSITIVE NORTHWARD
C     BATHY(I) IS THE BOTTOM DEPTH AT NODE I
C     U(I),V(I) ARE THE X AND Y DIRECTED VELOCITIES OF NODE I
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
C...BEGIN variable declaration and defining parameters
C...BEGIN variable declaration and defining parameters
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

C
C...Declare all the integer program parameters via INCLUDE file
C
      INCLUDE 'ACADIA.DIM'
C
C...Mesh arrays dimensioning
C
      INTEGER IN(3,NEDIM)
      REAL X(NNDIM), Y(NNDIM),BATHY(NNDIM), SV(NNDIM)
      REAL RHSC(NNDIM)

C...Velocity arrays dimensioning
	REAL U(NNDIM),V(NNDIM)

C...diffusivity arrays dimensioning
	real ah(nndim)
C...flux array dimensioning (current & cumulative)
      REAL FLX(NNDIM),FLXB(NNDIM),CFLX(NNDIM),GBC(NNDIM)
C
C...percentage of germination array dimensioning
      REAL PINIT(NNDIM),PBED(NNDIM),PGERM(NNDIM)
C
C...Concentration array dimensioning
      REAL C(NNDIM), RC(NNDIM)    
C
C...Array declaration for sparse matrix storage
      INTEGER IQ(NNDIM), JQ(NFTRDIM*NNDIM)
      REAL PPX(NFTRDIM*NNDIM), PPY(NFTRDIM*NNDIM)

C...Convective arrays dimensioning
C...AGPGP IS THE SPARSE VISCOUS MATRIX
      REAL AGPGP(NFTRDIM*NNDIM)

C...Variable declaration for I/O formatting
      CHARACTER*72 CASNAM
      CHARACTER*72 FILINP

C...other
	Integer iter,kd, kdq, ntv, nn, ne,bday
	REAL deg, delt, ssec, ssecq


        real DIFFUS(NTVDIM), DCDX(NTVDIM), DCDY(NTVDIM)
     
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
C...End of variable declaration and defining parameters
C...End of variable declaration and defining parameters
C
C--------------------------------------------------------------------
C-----------------------------------------------------------------------
C
C  OPEN ECHO FILE AND READ INPUT FILE ".inp"
C  OPEN ECHO FILE AND READ INPUT FILE ".inp"
C
C--------------------------------------------------------------------
C-----------------------------------------------------------------------
C
	FILINP = 'ACADIA.inp'
	CALL READ_INPUT(filinp,casnam,ntv,DEG,
     &              DELT,kd,ssec,kdq,ssecq)
	write(2,*) 'input file read in'

C--------------------------------------------------------------------
C-----------------------------------------------------------------------
C
C  DONE WITH INPUT; INITIALIZE
C  DONE WITH INPUT; INITIALIZE
C
C--------------------------------------------------------------------
C-----------------------------------------------------------------------
C Read mesh information from nod and ele files (names hardcoded in)
C Load Mesh Data: load coordinate data & load incidence list data
       CALL LOADMESHGOM(nndim,nedim,casnam,x,y,in,bathy,nn,ne)

C Timing Paramters
	iter=0
        bday=60
C get initial value of physical parameters
	call get_physics(casnam,NN,ne,deg,kd,ssec,
     &                      iter,x,y,bathy,u,v,ah,iahchg,bday)

	write(2,*) 'physical transport variables initialized'
C set up sparse storage matrices
	call sparsestor(nn,ne,in,x,y,iter,bathy,ah,
     &                iq,jq,sv,ppx,ppy,agpgp)
	
	write(2,*) 'sparse storage initalized'
C set inital conditions
	call ics(nn,ntv,bathy,pbed,pinit,c,gbc)
ccc       open(unit=33,file='vel_mj.dat',status='new')
        do 5 i=1,nn
ccc       write(33,'(i4,2E12.3)') i,u(i),v(i)
          flx(i)=0.0
          flxb(i)=0.0
          cflx(i)=0.0
          pgerm(i)=0.0
 5     continue  
ccc         close(33)
c initialization call to output
	call output(NN,ntv,NE, CASNAM,kd,ssec,iter,delt,
     &       u,v,bathy,C,pinit,pbed,pgerm,flx,flxb,cflx,gbc)
C
C--------------------------------------------------------------------
C-----------------------------------------------------------------------
C
C  DONE WITH INITIALIZATION
C  DONE WITH INITIALIZATION
C
C-----------------------------------------------------------------------
C                
C  END OF PREPARATION ... BEGIN TIME STEP LOOP       
C  END OF PREPARATION ... BEGIN TIME STEP LOOP       
C                
C-----------------------------------------------------------------------
	write(2,*) 'beginning time stepping loop'

   80  continue

C call reaction subroutine every time step (based on c at time k)
      CALL rxn(nn,ntv,bday,delt,kd,iter,bathy,gbc,pinit,pbed,
     &      flx,flxb,cflx,pgerm,rc)  


C compute net local change from advection,diffusion and reaction
c (all transport terms u,v,and ah here are evaluated at time k)
      DO 110 I=1,NN
C
       CALL SPRSMLTIS3 (I, PPX,ppy,agpgp, 
     &                  IQ, JQ, C, 
     &                  DCDX,dcdy,diffus,
     &                  Ntv, NNDIM,ntvdim)
	

ccc      DO 120 m=1,ntv
      RHSC(I) =-U(I)*DCDX(ntv)-V(I)*DCDY(ntv)
     &                 +DIFFUS(ntv)
     &                 +RC(I)*C(I)
ccc 120  CONTINUE
 110  CONTINUE


C apply boundary condition effect to right hand side
c (the velocity sent here is for time k)

	call bcs(ntv,casnam,x,y,bathy,
     &               u,v,delt,sv,iter,kd,ssec,c,rhsc)

C------------------------------------------------------------
C------------------------------------------------------------
C
C  UPDATE VARIABLES
C  UPDATE VARIABLES
C
C------------------------------------------------------------
c increments timing parameters
c set all concentrations, and physics for k+1
	iter=iter+1

C checks if needs to update kd
C 86400 is the number of seconds in 1 day
      ssec     =     ssec+DELT            
	if (ssec.ge.8.64E4) then
          call up_date(kd,ssec)
          bday=bday+1
        write(2,*) 'current day is...'
        write(2,*) kd,ssec,bday
        end if
C updates concentration for this time
	DO 130 I=1,NN
C add cells due to vertical cell flux
        if (gbc(I).NE.-99) C(I)=C(I)+flx(I)
	C(I)=C(I)+delt*RHSC(I)
        if (C(I).lt.0.0) C(I)=0.0 

  130 CONTINUE

C get physical paramters for new time
	  call get_physics(casnam,NN,ne,deg,kd,ssec,
     &                   iter,x,y,bathy,u,v,ah,iahchg,bday)

C reset diffusive matrix if d varies in tidal time
	if (iahchg.eq.1) then
	  call sparsestor(nn,ne,in,x,y,iter,bathy,ah,
     &                 iq,jq,sv,ppx,ppy,agpgp)
	end if
C
C
C call output with time variables 
	call output(NN,ntv,NE, CASNAM,kd,ssec,iter,delt,
     &       u,v,bathy,C,pinit,pbed,pgerm,flx,flxb,cflx,gbc)
C------------------------------------------------------------
C------------------------------------------------------------
C
C  THE TIME STEP IS COMPLETE
C  THE TIME STEP IS COMPLETE
C
C------------------------------------------------------------
C------------------------------------------------------------
C 
C  CHECK VELOCITY FIELD UPDATE CRITERIA
C  AND RETURN FOR ANOTHER TIME STEP (k+1 --> k) OR STOP 


       IF (kd.lt.kdq)go to 740
       if ((kd.eq.kdq).and.(ssec.lt.ssecq)) GO TO 740

	call dmy(id,im,iy,kd)
      WRITE (2,*) ' '
      WRITE (2,*) ' '
      WRITE (2,*) '********',
     &              'EXECUTION TERMINATED AT --', 
     &              iter,id,im,iy,ssec, ' *******'
       close(2)
       close(3)
      STOP

740   CONTINUE

      GO TO 80
	end
