/*
 * ProcessedDataParser.java
 *
 * Created on March 16, 2007, 2:09 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package fixeddisplay;
import CommonThreads.*;
import java.util.*;
import java.io.*;

/**
 *
 * @author Julia J. Robinson
 */
public class ProcessedDataParser extends ParserThread
{
    // for use within the Parser's thread 
    boolean parsingSettings;
    boolean parsingDataScan;
    boolean parsingFieldDefinition;
    String lastText;
    FieldDefinition curFieldDefinition;
    
    ProcessedDataParserEventListener the_event_listener;
    
    // Runs in the parser thread.  May publish events.  May not manipulate the GUI.
    public void startElement(String tag, Map<String, String> mapAttribs) throws Exception
    {
        lastText = null;
        if (!parsingDataScan  && tag.equals("Scan"))
        {
            // there is only one attribute that we care about
            String attribName = "index";
            String attribValue = mapAttribs.get(attribName);
            if (null != attribValue)
            {
                int n = Integer.parseInt(attribValue);
                publish(new SWTEventBeginScan(n));
                parsingDataScan = true;
                return;
            }
        }
        if (parsingSettings && !parsingFieldDefinition && tag.equals("FieldDefinition"))
        {
            curFieldDefinition = new FieldDefinition();
            if (null != curFieldDefinition)
            {
                parsingFieldDefinition = true;                
            }
            lastText = null;
        }
        if (!parsingSettings && tag.equals("SBE_ConvertedDataSettings"))
        {
            parsingSettings = true;
            publish(new SWTEventBeginSettings());
        }
    }
    
    public void endElement(String tag) throws Exception
    {
        if (parsingDataScan)
        {
            if (tag.equals("Scan"))
            {
                parsingDataScan = false;
                publish (new SWTEventEndScan());
            }
            else
            {
                // data field
                publish (new SWTEventFieldValue(tag, lastText));
            }
            return;
        }
        if (parsingSettings)
        {
            if (parsingFieldDefinition && (null != curFieldDefinition) && (tag.equals("FieldDefinition")))
            {
                parsingFieldDefinition = false;
                SWTEventFieldDefinition cur_event = new SWTEventFieldDefinition(curFieldDefinition);
                curFieldDefinition = null;
                publish(cur_event);
                return;
            }
            if (parsingFieldDefinition && (null != curFieldDefinition) && (null != lastText))
            {
                if (tag.equals("CalcID"))
                {
                    curFieldDefinition.setCalcID(Integer.parseInt(lastText));    
                }
                else if (tag.equals("UnitID"))
                {
                    curFieldDefinition.setUnitID(Integer.parseInt(lastText));
                }
                else if (tag.equals("Ordinal"))
                {
                    curFieldDefinition.setOrdinal(Integer.parseInt(lastText));
                }
                else if (tag.equals("Units"))
                {
                    curFieldDefinition.setUnits(lastText);
                }
                else if (tag.equals("FullName"))
                {
                    curFieldDefinition.setFullName(lastText);
                }
                else if (tag.equals("Tag"))
                {
                    curFieldDefinition.setXMLtag(lastText);
                }
                else
                {
                    System.out.println("Unexpected tag inside a FieldDefinition - " + tag);
                }
                lastText = null;
                return;
            }
            if (tag.equals("SBE_ConvertedDataSettings"))
            {
                parsingSettings = false;
                publish (new SWTEventEndSettings());
                return;
            }
        }
    //    System.out.println("</" + tag + ">");
    }
    public void startDocument() throws Exception
    {
    //    System.out.println("start document");
    }
    public void endDocument() throws Exception
    {
    //    System.out.println("end document");
    }
    public void text(String str) throws Exception
    {
        lastText = str;
    }

    // stub - should be passed on to another class that will start up the thread if needed.
    int OnParserThreadExit()
    {
        System.out.println("Parser thread has exited.");
        return 0;
    }
    /** Creates a new instance of ProcessedDataParser */
    public ProcessedDataParser(
                    ProcessedDataParserEventListener listner, 
                    Reader theReader) 
    {
        super (theReader);
        the_event_listener = listner;
        parsingSettings = false;
        parsingDataScan = false;
        parsingFieldDefinition = false;
        curFieldDefinition = null;
        lastText = null;
    }
    
    protected int OnParserThreadExit(String message)
    {
        return the_event_listener.OnParserThreadExit(message);
    }
    
    
    class SWTEventBeginScan implements SWTEvent
    {
        int index;
        
        SWTEventBeginScan(int n)
        {
            index = n;
        }
        public int Execute()
        {
            return the_event_listener.OnBeginScan(index);
        }
    }
    class SWTEventEndScan implements SWTEvent
    {
        SWTEventEndScan()
        {
        }
        public int Execute()
        {
            return the_event_listener.OnEndScan();
        }
    }
    class SWTEventBeginSettings implements SWTEvent
    {
        SWTEventBeginSettings()
        {
        }
        
        public int Execute()
        {
            return the_event_listener.OnStartSettings();
        }
    }
    
    class SWTEventEndSettings implements SWTEvent
    {
        SWTEventEndSettings()
        {
        }
        public int Execute()
        {
            return the_event_listener.OnEndSettings();
        }
    }
    
    class SWTEventFieldValue implements SWTEvent
    {
        String theTag;
        String theValue;
        
        SWTEventFieldValue(String tag, String value)
        {
            theTag = tag;
            theValue = value;
        }
        
        public int Execute()
        {
            return the_event_listener.OnFieldValue(theTag, theValue);
        }
    }
    
    class SWTEventFieldDefinition implements SWTEvent
    {
        FieldDefinition the_fd;
        
        SWTEventFieldDefinition(FieldDefinition fd)
        {
            the_fd = fd;
        }
        
        public int Execute()
        {
            return the_event_listener.OnFieldDefinition(the_fd);
        }
    }
}
