/*
 * FieldDefinition.java
 *
 * Created on March 19, 2007, 12:42 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package fixeddisplay;

/**
 * Contains settings for one calculated data field.
 * @author Julia J. Robinson
 */
public class FieldDefinition 
{
    /** Full name of the data calculated.*/
    String fullName;
    /** Integer that identifies the calculation. */
    int calcID;
    /** Integer that identifies the unit. */
    int unitID;
    int ordinal;
    String units;
    /** XML tag used to identify this field in the data scan.*/
    String xmlTag;
    
    /** Creates a new instance of FieldDefinition */
    public FieldDefinition() 
    {
        fullName = "";
        calcID = -1;
        unitID = -1;
        ordinal = -1;
        units = "";
        xmlTag = "";
    }
    public int getCalcID()
    {
        return calcID;
    }
    public void setCalcID(int id)
    {
        calcID = id;
    }
    public int getUnitID()
    {
        return unitID;
    }
    public void setUnitID(int id)
    {
        unitID = id;
    }
    public int getOrdinal()
    {
        return ordinal;
    }
    public void setOrdinal(int ord)
    {
        ordinal = ord;
    }
    public String getFullName()
    {
        return fullName;
    }
    public void setFullName(String fn)
    {
        fullName = fn;
    }
    public String getUnits()
    {
        return units;
    }
    public void setUnits(String u)
    {
        units = u;
    }
    public String getXMLtag()
    {
        return xmlTag;
    }
    public void setXMLtag(String tag)
    {
        xmlTag = tag;
    }

    public String toString() 
    {
        String rv = "<Field>";
        rv += "<CalcID>" + Integer.toString(getCalcID()) + "</CalcID>";
        rv += "<UnitID>" + Integer.toString(getUnitID()) + "</UnitID>";
        rv += "<Ordinal>" + Integer.toString(getOrdinal()) + "</Ordinal>";
        rv += "<Units>" + getUnits() + "</Units>";
        rv += "<FullName>" + getFullName() + "</FullName>";
        rv += "<Tag>" + getXMLtag() + "</Tag>";
        rv += "</Field>";
        return rv;
    }
}
