/*
 * EventCoordinator.java
 *
 * Created on March 16, 2007, 2:06 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package fixeddisplay;
import CommonThreads.*;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.SwingWorker;
import java.net.SocketAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.io.IOException;
import java.util.List;
/**
 * This class is the brains behind the FixedDisplay application.
 *
 * @author Julia J. Robinson
 */
public class EventCoordinator implements SWTReceiverEventListener, 
                                         FixedDisplayEventListener,
                                         ProcessedDataParserEventListener
{
    private FixedDisplayUI the_user_interface;
    ConnectInformation con_info;
    CharactersReceived chars_recvd;
    ArrayList<FieldDefinition> the_field_definitions;
    int count_field_definitions;
    ReceiverThread the_receiver_thread;
    
    volatile Boolean have_received_settings;
    volatile Boolean receiver_thread_is_running;
    /**
     * Entry point for the FixedDisplay application.
     *
     * @param args the command line arguments
     */
    public static void main(final String args[]) 
    {
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() 
        {
            public void run() 
            {
                EventCoordinator ec = new EventCoordinator(args);
                FixedDisplayUI fd_ui = new FixedDisplayUI(ec);
                ec.FinalConstruct(fd_ui);
                fd_ui.setVisible(true);
            }
        });
    }
    
    /** Initialization for the EventCoordinator after it is constructed. */
    public void FinalConstruct(FixedDisplayUI theGUI)
    {
        the_user_interface = theGUI;
        the_user_interface.SetPort(con_info.GetPortInput());
        the_user_interface.SetServerAddress(con_info.GetServerAddress());
        the_receiver_thread = null;
        have_received_settings = false;
        receiver_thread_is_running = false;
        // start a SwingWorker thread to parse what comes from the socket.
        (new ProcessedDataParser(this, chars_recvd)).execute();
    }
    /** Creates a new instance of EventCoordinator. */
    public EventCoordinator(final String[] args)
    {
        System.out.println("Constructing the EventCoordinator");
        con_info = new ConnectInformation();
        count_field_definitions = 0;
        if (args.length > 0)
        {
            con_info.SetServerAddress(args[0]);
        }
        if (args.length > 1)
        {
            con_info.SetPortInput(Integer.parseInt(args[1]));
        }
        chars_recvd = new CharactersReceived();
        the_field_definitions = new ArrayList<FieldDefinition>();
     //   map_index_lookup = new Map<String, Integer>();
    }
    
    /** Called when ReceiverThread.doInBackground exits. */
    public int OnReceiverThreadExit(String exit_message)
    {
        System.out.println("OnReceiverThreadExit - " + exit_message);
        receiver_thread_is_running = false;
        // disconnect, or connection was refused.
        the_user_interface.ShowConnectPannel(the_user_interface.ENABLE_CONNECT);
        return 0;
    }
    
    // FixedDisplayEventListener interface implementation
    
    /** Called when user presses the Connect button. */
    public void OnButtonConnect()
    {
        System.out.println("EventCoordinator.OnButtonConnect()");
        
        // get user's input from GUI
        con_info.SetPortInput(the_user_interface.GetPort());
        con_info.SetServerAddress(the_user_interface.GetServerAddress());
             
        // Start up a thread for receiving stuff via a socket
        the_receiver_thread = new ReceiverThread(chars_recvd, con_info, this);
        if (null != the_receiver_thread)
        {
            receiver_thread_is_running = true;
            the_receiver_thread.execute();

            // start up a thread that will time things.
            ConnectTimerThread thread = new ConnectTimerThread();
            if (thread != null)
            {
                have_received_settings = false;
                the_user_interface.ShowConnectPannel(
                    the_user_interface.ENABLE_NEITHER_CONNECT_NOR_DISCONNECT);
                
                thread.execute();
            }
            else
            {
                System.out.println("EventCoordinator.OnButtonConnect() - low on memory!");
            }
        }
    }
    /** Called when user presses the Disconnect button. */
    public void OnButtonDisconnect()
    {
        if (null != the_receiver_thread) 
        {
            the_receiver_thread.ForceDisconnect();
            the_receiver_thread = null;
        }
    }
    /** Called when ParserThread.doInBackground exits. */
    public int OnParserThreadExit(String message)
    {
        // app is shutting down, or a bad error occurred.
        System.out.println(message);
        return 0;
    }
    
    // ProcessedDataParserEventListener interface
    
   
    public int OnBeginScan(int index)
    {
        return 0;
    }
    public int OnFieldValue(String tag, String value)
    {
        // find the index and display it.
        if (tag.length() > 5 && tag.startsWith("Field"))
        {
            try
            {
                int index = Integer.parseInt(tag.substring(5));
                the_user_interface.SetParameterValue(index, value);
            }
            catch (Exception e)
            {
                
            }
        }
        return 0;
    }
    
    
    public int OnEndScan()
    {
        return 0;
    }
    
    public int OnStartSettings()
    {
        // hide all of the displays
        final int max_displays = the_user_interface.GetMaxParametersDisplayed();
        for (int i = 0; i < max_displays; ++i)
        {
            the_user_interface.ShowParameterDisplay(i, false);
        }
        // make our collection of field definitions empty
        the_field_definitions.clear();
        count_field_definitions = 0;
        return 0;
    }
    
    public int OnSecondsBetweenUpdates(double seconds)
    {
        // not really relevant
        return 0;
    }
    public int OnFieldDefinition(FieldDefinition fd)
    {
        System.out.println("EventCoordinator::OnFieldDefinition() received " + fd.toString());
        System.out.println();
        
        // add the field definition to our collection
        the_field_definitions.add(fd);
        
        count_field_definitions++;
        
        return 0;
    }
    public int OnEndSettings()
    {
        have_received_settings = true;
        // Show parameter display controls, with full names of fields.
        for (int i = 0; 
             i < count_field_definitions && 
                i < the_user_interface.GetMaxParametersDisplayed();
             ++i)
        {
            FieldDefinition fd = the_field_definitions.get(i);
            String full_name = fd.getFullName();
            the_user_interface.SetParameterName(i, full_name);
            the_user_interface.ShowParameterDisplay(i, true);
        }
        return 0;
    }

    void ConnectThreadDone(Boolean bResult)
    {
        if (receiver_thread_is_running && have_received_settings)
        {
            the_user_interface.ShowConnectPannel(the_user_interface.ENABLE_DISCONNECT);
        }
        else if (receiver_thread_is_running)
        {
            the_receiver_thread.ForceDisconnect();
            the_user_interface.ShowConnectPannel(the_user_interface.ENABLE_CONNECT);
        }
        else
        {
            the_user_interface.ShowConnectPannel(the_user_interface.ENABLE_CONNECT);
        }
    }
    
    // Thread for connecting to Seasave
    private final class ConnectTimerThread extends SwingWorker<Integer, Integer>
    {
        volatile boolean m_bResult;
        
        ConnectTimerThread()
        {
            m_bResult = false;
        }
        protected Integer doInBackground() throws InterruptedException 
        {
            m_bResult = false;
                
            for (int i = 0; 
                 i < 100 && !have_received_settings 
                        && receiver_thread_is_running; 
                 ++i)
            {
                try
                {
                    Thread.currentThread().sleep(100);
                }
                catch (Exception e)
                {
                    System.out.println(e.toString());
                }
            }
            if (have_received_settings && receiver_thread_is_running)
            {
                m_bResult = true;
            }
            return 0;
        }

        
        // This is called in the GUI's thread with lists of events that have been
        // published.  This particular thread doesn't publish anything.
        protected void process(List<Integer> eventList) 
        {
           for ( Integer pevt: eventList) 
           {
               System.out.println("ConnectTimerThread.process() got a " 
                       + Integer.toString(pevt));
           }
        }// end ConnectTimerThread.process()
        
        protected void done()
        {
             System.out.println("ConnectTimerThread.done - " + 
                     Boolean.toString(m_bResult));
             ConnectThreadDone(m_bResult);
        }// end ConnectTimerThread.done
        
    }// end class ConnectTimerThread
}
