/*
 * SWTCommandListener.java
 */

package firebottles;

/**
 * The EventCoordinator will implement this interface, in order to receive 
 * commands published by the worker threads.
 *
 * The SwingWorker<T, T>.Process()and SwingWorker<T,T>.Done will call functions 
 * defined in this interface.
 *
 * @author Julia J. Robinson
 */
public interface SWTCommandListener 
{
    // status message received
    public int OnStatus(BottleFireStatus bfs);
    // confirmation of bottle fire received
    public int OnBottleFired(int bottleNumber);
    public int OnNextBottleFired();
    // parser errors, exceptions, and whatever
    public int OnError(String str_error);
    public int OnError(int error_number);
    // parser thread exiting
    public int OnParserThreadExit();   
    // socket receiver thread exiting
    public int OnReceiverThreadExit(String exit_message);
}
