package firebottles;
import javax.swing.JOptionPane;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.JTabbedPane;
import javax.swing.JPanel;
import javax.swing.JFrame;
import firebottles.ConnectPanel;
import firebottles.FirePanel;
import java.awt.BorderLayout;

/*
 * RemoteBottleFireGui.java requires these files:
 *   CustomDialog.java
 *   images/middle.gif
 */
public class RemoteBottleFireGui extends JPanel
{
    JFrame frame;
    String connectPanelDescription = "Connect";
    String moreDialogDesc = "Fire";
        
    ConnectPanel connectPanel;
        
    FirePanel firePanel;

    private GUICommandListener owner;

    /** Creates the GUI shown inside the frame's content pane. */
    public RemoteBottleFireGui(JFrame frame, GUICommandListener gcl) 
    {
        super(new BorderLayout());
        this.owner = gcl;
        this.frame = frame;
        //Create the components.
        connectPanel = new ConnectPanel(gcl);
        firePanel = new FirePanel(gcl);
        
        //Lay them out.
        Border padding = BorderFactory.createEmptyBorder(1, 1, 1, 1);//(20,20,5,20);
        connectPanel.setBorder(padding);
        firePanel.setBorder(padding);

        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Connect", null,
                          connectPanel,
                          connectPanelDescription); //tooltip text
        tabbedPane.addTab("Fire", null,
                          firePanel,
                          moreDialogDesc); //tooltip text

        add(tabbedPane, BorderLayout.CENTER);
    }

    public void EnableConnectPanelControls(int nState) 
    {
        System.out.println("RemoteBottleFireGui.EnableConnectPanelControls - nState = " + Integer.toString(nState));
        connectPanel.EnableConnectPanelControls(nState);
    }

    /**
     * Create the GUI and show it.  For thread safety,
     * this method should be invoked from the
     * event-dispatching thread.
     */
    public static RemoteBottleFireGui createAndShowGUI(GUICommandListener owner) 
    {
        //Create and set up the window.
        JFrame frame = new JFrame("Remote Bottle Fire for Seasave");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        //Create and set up the content pane.
        RemoteBottleFireGui newContentPane = new RemoteBottleFireGui(frame, owner);

        newContentPane.setOpaque(true); //content panes must be opaque

        frame.setContentPane(newContentPane);

        //Display the window.
        frame.pack();
        frame.setVisible(true);
        
        return newContentPane;
    }

    // Get and Set methods to pass on to the connectPanel
    public int GetInputPort() 
    {
         return connectPanel.GetInputPort();
    }
    public void SetInputPort(int nPort) 
    {
         connectPanel.SetInputPort(nPort);
    }
    
    public int GetOutputPort() 
    {
        return connectPanel.GetOutputPort();
    }
    
    public void SetOutputPort(int nPort) 
    {
        connectPanel.SetOutputPort(nPort);
    }
    
    // Get and Set methods to pass on to the Fire panel
    public String GetServerAddress() 
    {
        return connectPanel.GetServerAddress();
    }
    
    public void SetServerAddress(String address) 
    {
        connectPanel.SetServerAddress(address);
    }

    // Get and Set methods to pass on to the Fire panel.
    public int GetNextBottle() 
    {
        return firePanel.GetNextBottle();
    }
    public void SetNextBottle(int nextBottle)
    {
        firePanel.SetNextBottle(nextBottle);
    }
    
    public void SetBottleFireSequence(String strSequence)
    {
        firePanel.SetBottleFireSequence(strSequence);
    }
    
    public void SetNumberOfBottles(int number)
    {
        firePanel.SetNumberOfBottles(number);
    }
    
    public void SetWaterSamplerType(String type)
    {
        firePanel.SetWaterSamplerType(type);
    }
    
    public void SetNumberFired(int number)
    {
        firePanel.SetNumberFired(number);
    }
    
    public void EnableNextBottle(boolean bEnable)
    {
        firePanel.EnableNextBottle(bEnable);
    }
    
    public void EnableFire(boolean bEnable)
    {
        firePanel.EnableFire(bEnable);
    }
}
