/*
 * FireBottlesParser.java
 *
 * Created on February 22, 2007, 3:14 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package firebottles;
import javax.swing.SwingWorker;
import ThirdParty.DocHandler;
import ThirdParty.QDParser;
import CommonThreads.ParserThread;
import CommonThreads.SWTEvent;
import java.util.*;
import java.io.*;
import firebottles.SWTCommandListener;
import firebottles.BottleFireStatus;
/**
 * In the Producer/Consumer paradigm, this is the Consumer.<br><br>
 * 
 * This class takes characters off the queue one at a time and feeds them to
 * the quick-and-dirty XML parser.<br><br>
 * 
 * The parser calls methods of the DocHandler interface, implemented by this 
 * class, when it comes to tags, text nodes, etc.  These DocHandler methods 
 * will instantiate and publish the appropriate SWTEvent's
 * containing the needed information.  This all happens in the thread of 
 * SwingWorker<T,T>.doInBackground.<br><br>
 * 
 * This class implements SwingWorker<T,T>.process, which is called from within the
 * user interface thread, so that it has permission to manipulate components of
 * the GUI.  Events are removed from the list, and appropriate methods of the
 * GUI are called - the GUI has to implement the SWTCommandListener interface
 * for this to happen.<br><br>
 * 
 * 
 * @author Julia J. Robinson
 */
public class FireBottlesParser 
        extends ParserThread
        implements DocHandler
{
    SWTCommandListener gui_for_this_application;
    Reader chars_from_socket_receiver;
    private BottleFireStatus bottle_fire_status;
    private String lastTextFromParser;
    private volatile boolean threadMustExit;
    
    
    /**
     * Creates a new instance of FireBottlesParser
     */
    public FireBottlesParser(SWTCommandListener theGui, Reader theReader) 
    {
        super (theReader);
        gui_for_this_application = theGui;
        chars_from_socket_receiver = theReader;
        lastTextFromParser = "";
        bottle_fire_status = new BottleFireStatus();
        threadMustExit = false;
    }
    public void SetThreadExitFlag()
    {
        threadMustExit = true;
    }
    
    protected int OnParserThreadExit(String message)
    {
        return 0;//stub!
    }

/*    
    // doInBackground is the function that runs in a worker thread.
    @Override
    protected SWTEvent doInBackground() 
    {
        while (!threadMustExit)
        {
            try
            {
                QDParser.parse(this, chars_from_socket_receiver);
                System.out.println("doInBackground - QDParser.parse has finished.");
            }
            catch (Exception exc)
            {
                System.out.println("doInBackground - QDParser threw an exception - " + exc.toString());
            }
        }
        return new EventParserThreadExit();
   }
 */ 
        // XML tags in status message
	private final String tagStatus               = "Status";
	private final String tagWaterSamplerType     = "WaterSamplerType";
	private final String tagNumberOfBottles      = "NumberOfBottles";
	private final String tagFiringIsEnablede     = "FiringEnabled";
	private final String tagNumberOfBottlesFired = "NumberOfBottlesFired";
	private final String tagBottleFireSequence   = "BottleFireSequence";
        // other XML tags to look for
        private final String tagNextBottleFired      = "NextBottleFired";
        private final String tagBottleFired          = "BottleFired";
        private final String tagParseError           = "ParseError";
        private final String tagError                = "Error";
  // Methods of the DocHandler interface, called within WDParser.parse  
  public void startElement(String tag, Map<String, String> h) throws Exception
  {
      lastTextFromParser = "";
  }
  
  // called by the parser whenever an element ends.
  public void endElement(String tag) throws Exception
  {
      if (tagStatus.equals(tag))
      {
           System.out.println("DocHandler.endElement - tag == Status");
         publish(new EventStatus(bottle_fire_status));
      }
      else if (tagWaterSamplerType.equals(tag))
      {
          System.out.println("DocHandler.endElement - tag == WaterSamplerType");
          bottle_fire_status.SetWaterSamplerType(LastTextToInt(0));
      }
      else if (tagNumberOfBottles.equals(tag))
      {
          System.out.println("DocHandler.endElement - tag == NumberOfBottles");
          bottle_fire_status.SetNumberOfBottles(LastTextToInt(0));
      }
      else if (tagNumberOfBottlesFired.equals(tag))
      {
          System.out.println("DocHandler.endElement - tag == NumberOfBottlesFired");
          bottle_fire_status.SetNumberOfBottlesFired(LastTextToInt(0));
      }
      else if (tagFiringIsEnablede.equals(tag))
      {
           System.out.println("DocHandler.endElement - tag == FiringIsEnabled");
         bottle_fire_status.SetFiringIsEnabled(0 != LastTextToInt(0));
      }
      else if (tagBottleFireSequence.equals(tag))
      {
         System.out.println("DocHandler.endElement - tag == BottleFireSequence");
         bottle_fire_status.SetFiringSequence(lastTextFromParser);
      }
      else if (tagNextBottleFired.equals(tag))
      {
          System.out.println("DocHandler.endElement - tag == NextBottleFired");
          publish(new EventNextBottleFired());
      }
      else if (tagBottleFired.equals(tag))
      {
          System.out.println("DocHandler.endElement - tag == BottleFired");
          int bottleNumber = LastTextToInt(0);
          if (bottleNumber > 0)
          {
                publish (new EventBottleFired(bottleNumber));
          }
          else
          {
              publish (new EventError("Bottle number missing from BottleFired message."));
          }
      }
      else if (tagParseError.equals(tag))
      {
          System.out.println("DocHandler.endElement - tag == ParseError");
          publish (new EventError("ParseError"));
      }
      else if (tagError.equals(tag))
      {
          System.out.println("DocHandler.endElement - tag == Error");
          int errorNumber = LastTextToInt(-1);
          if (errorNumber > -1)
          {
              publish (new EventError(errorNumber));
          }
          else if (lastTextFromParser.length() > 0)
          {
              publish (new EventError(lastTextFromParser));
          }
          else
          {
              publish (new EventError("unknown error"));
          }
      }
      else
      {
            System.out.println("DocHandler.endElement - unexpected tag - " + tag);
      }
      lastTextFromParser = "";
  }
  
  public void startDocument() throws Exception
  {
     System.out.println("DocHandler.startDocument() - ignored.") ;
  }
  public void endDocument() throws Exception
  {
      System.out.println("DocHandler.endDocument() - ignored.") ;
     
  }
  public void text(String str) throws Exception
  {
      System.out.println("DocHandler.text - " + str);
      lastTextFromParser = str;
  }
/*
  // This is called in the GUI's thread with lists of events that have been
  // published.
  protected void process(List<SWTEvent> eventList) 
  {
       for ( SWTEvent pevt: eventList) 
       {
           // Execute calls the appropriate method of the GUI,
           // passing it any necessary information.
           pevt.Execute();
       }
  }
*/
  // class EventBottleFired - for publication by the DocHandler
  class EventBottleFired implements SWTEvent
  {
      int bottleNumber;
      
      public EventBottleFired(int number)
      {
          bottleNumber = number;
      }
      
      public int Execute()
      {
          return gui_for_this_application.OnBottleFired(bottleNumber);
      }
  }
  // class EventNextBottleFired - for publication by the DocHandler
  class EventNextBottleFired implements SWTEvent
  {
      public EventNextBottleFired()
      {
      }
      
      public int Execute()
      {
          return gui_for_this_application.OnNextBottleFired();
      }
  }
  
    // class EventStatus - for publication by the DocHandler
    class EventStatus implements SWTEvent
    {
          BottleFireStatus status;
          public EventStatus(BottleFireStatus st)
          {
              status = new BottleFireStatus(st);
          }

          public int Execute()
          {
              // TODO: This message, and the parameter to OnStauts, need a BottleFireStatus parameter.
              return gui_for_this_application.OnStatus(status);
          }
    }
    
    
  // class EventParserThreadExit - returned by SwingWorker.doInBackground
  class EventParserThreadExit implements SWTEvent
  {
      public EventParserThreadExit()
      {
      }
      
      public int Execute()
      {
          return gui_for_this_application.OnParserThreadExit();
      }
  }
  
  // class EventError - for publication by the DocHandler
   class EventError implements SWTEvent
  {
      int nError;
      String strError;
      public EventError(String str)
      {
          nError = -1;
          strError = str;
      }
       public EventError(int errnum)
      {
          nError = errnum;
          strError = "";
      }
     
      public int Execute()
      {
          if (strError.length() != 0)
          {
            return gui_for_this_application.OnError(strError);
          }
          return gui_for_this_application.OnError(nError);
      }
  }

    private int LastTextToInt(int default_value) 
    {
        int return_value = default_value;
        try
        {
            if (lastTextFromParser.length() != 0)
            {
                return_value = Integer.parseInt(lastTextFromParser);
            }
        }
        catch (Exception exc)
        {
        }
        return return_value;
    }

}
