/*
 * ConnectPanel.java
 *
 * Created on February 26, 2007, 2:06 PM
 */

package firebottles;

/**
 *
 * @author  Julia J. Robinson
 */
public class ConnectPanel extends javax.swing.JPanel 
{
    GUICommandListener owner;
    
    /** Creates new form ConnectPanel */
    public ConnectPanel(GUICommandListener gcl) 
    {
        owner = gcl;
        initComponents();
        this.jtextInputPort.setText("49168");
        this.jtextOutputPort.setText("49167");
        this.jtextServerAddress.setText("127.0.0.1");
    }

    public int GetInputPort() 
    {
        int rval = 0;
        try 
        {
            String str = jtextInputPort.getText();
            rval = Integer.parseInt(str);
        }
        catch (Exception e)
        {
            
        }
        return rval;
    }
    public void SetInputPort(int nPort) 
    {
         jtextInputPort.setText(Integer.toString(nPort));
    }
    
    public int GetOutputPort() 
    {
        int rval = 0;
        try 
        {
            String str = jtextOutputPort.getText();
            rval = Integer.parseInt(str);
        }
        catch (Exception e)
        {
            
        }
        return rval;
    }
    
    public void SetOutputPort(int nPort) 
    {
         jtextOutputPort.setText(Integer.toString(nPort));
    }
    
    public String GetServerAddress() 
    {
        return jtextServerAddress.getText();
    }
    
    public void SetServerAddress(String address) 
    {
         jtextServerAddress.setText(address);
    }

    public void EnableConnectPanelControls(int nState) 
    {
        System.out.println(
                "ConnectPanel.EnableConnectPanelControls: state = " + Integer.toString(nState)
                );
        boolean bEnableConnect = false;
        boolean bEnableDisconnect = false;
        switch (nState)
        {
            case 0:
           //     System.out.println("EnableConnectPanelControls(0)");
                break;
            case 1:
          //      System.out.println("EnableConnectPanelControls(1)");
                bEnableConnect = true;
                break;
            case 2:
           //     System.out.println("EnableConnectPanelControls(2)");
                bEnableDisconnect = true;
                break;
            default:
                break;
        }

        this.jbuttonConnect.setEnabled(bEnableConnect);
        this.jtextInputPort.setEnabled(bEnableConnect);
        this.jtextOutputPort.setEnabled(bEnableConnect);
        this.jtextServerAddress.setEnabled(bEnableConnect);
        this.jbuttonDisconnect.setEnabled(bEnableDisconnect);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jlabelServerAddress = new javax.swing.JLabel();
        jtextServerAddress = new javax.swing.JTextField();
        jlabelInputPort = new javax.swing.JLabel();
        jtextInputPort = new javax.swing.JTextField();
        jlabelOutputPort = new javax.swing.JLabel();
        jtextOutputPort = new javax.swing.JTextField();
        jbuttonConnect = new javax.swing.JButton();
        jbuttonDisconnect = new javax.swing.JButton();

        jlabelServerAddress.setText("Server address:");

        jlabelInputPort.setText("Status port:");

        jlabelOutputPort.setText("Command port:");

        jbuttonConnect.setText("Connect");
        jbuttonConnect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbuttonConnectActionPerformed(evt);
            }
        });

        jbuttonDisconnect.setText("Disconnect");
        jbuttonDisconnect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbuttonDisconnectActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(66, 66, 66)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                .addComponent(jlabelInputPort, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(jlabelServerAddress, javax.swing.GroupLayout.Alignment.LEADING))
                            .addComponent(jlabelOutputPort))
                        .addGap(38, 38, 38)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jtextOutputPort, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jtextServerAddress, javax.swing.GroupLayout.PREFERRED_SIZE, 140, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jtextInputPort, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jbuttonConnect, javax.swing.GroupLayout.PREFERRED_SIZE, 117, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jbuttonDisconnect, javax.swing.GroupLayout.PREFERRED_SIZE, 109, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(69, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(72, 72, 72)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jlabelServerAddress)
                    .addComponent(jtextServerAddress, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(22, 22, 22)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jlabelOutputPort)
                    .addComponent(jtextOutputPort, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(26, 26, 26)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jlabelInputPort)
                    .addComponent(jtextInputPort, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(21, 21, 21)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jbuttonConnect)
                    .addComponent(jbuttonDisconnect))
                .addContainerGap(123, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jbuttonDisconnectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbuttonDisconnectActionPerformed
        owner.OnButtonDisconnect();
    }//GEN-LAST:event_jbuttonDisconnectActionPerformed

    private void jbuttonConnectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbuttonConnectActionPerformed

        owner.OnButtonConnect();
    }//GEN-LAST:event_jbuttonConnectActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jbuttonConnect;
    private javax.swing.JButton jbuttonDisconnect;
    private javax.swing.JLabel jlabelInputPort;
    private javax.swing.JLabel jlabelOutputPort;
    private javax.swing.JLabel jlabelServerAddress;
    private javax.swing.JTextField jtextInputPort;
    private javax.swing.JTextField jtextOutputPort;
    private javax.swing.JTextField jtextServerAddress;
    // End of variables declaration//GEN-END:variables
    
}
