package firebottles;
/*
 * BottleFireStatus.java
 */

/**
 * This class holds information that comes from Seasave in the <Status/> message.
 */
public class BottleFireStatus {
    
    /** Creates a new instance of BottleFireStatus */
    public BottleFireStatus() 
    {
        numberOfBottles = 12;
        firingIsEnabled = false;
        waterSamplerType = 0;
        numberOfBottlesFired = 0;
        firingSequence = "";
    }

    /** Creates a new instance by copying another instance */
    public BottleFireStatus( BottleFireStatus copyMe) 
    {
        numberOfBottles = copyMe.numberOfBottles;
        firingIsEnabled = copyMe.firingIsEnabled;
        waterSamplerType = copyMe.waterSamplerType;
        numberOfBottlesFired = copyMe.numberOfBottlesFired;
        firingSequence = copyMe.firingSequence;
    }
   
    private volatile int numberOfBottles;
    private volatile boolean firingIsEnabled; 
    private volatile int waterSamplerType;
    private volatile int numberOfBottlesFired;
    private String firingSequence;

    public String GetFiringSequence()
    {
        return firingSequence;
    }
    public void SetFiringSequence(String newSequence)
    {
        firingSequence = newSequence;
    }
    /** Returns number of bottles in the water sampler. */
    public int GetNumberOfBottles() 
    {
        return numberOfBottles;
    }

    public void SetNumberOfBottles(int n) 
    {
        numberOfBottles = n;
    }
    /** Returns number of bottles fired in current cast. */
    public int GetNumberOfBottlesFired() 
    {
        return numberOfBottlesFired;
    }

    public void SetNumberOfBottlesFired(int n) 
    {
        numberOfBottlesFired = n;
    }

    /** Returns the type of water sampler:  
     * 1 = GO 1015              ;
     * 2 = GO 1016              ;
     * 3 = Hydro Bios           ;
     * 4 = IOW                  ;
     * 5 = SBE Carousel         ;
     * 6 = SBE ECO.
     */
    public int GetWaterSamplerType() 
    {
        return waterSamplerType;
    }

    public void SetWaterSamplerType(int type) 
    {
        waterSamplerType = type;
    }

    public boolean GetFiringIsEnabled() 
    {
        return firingIsEnabled;
    }

    public void SetFiringIsEnabled(boolean bEnabled) 
    {
        firingIsEnabled = bEnabled;
    }

    public String toString() 
    {
        String rv = "BottleFireStatus: FiringIsEnabled = ";
        rv += firingIsEnabled ? "true" : "false" ;
        rv += "; firingSequence = \"";
        rv += firingSequence + "\"; numberOfBottles = ";
        rv += Integer.toString(numberOfBottles) + "; numberOfBottlesFired = ";
        rv += Integer.toString(numberOfBottlesFired) + "; waterSamplerType = ";
        rv += Integer.toString(waterSamplerType) + ";";
                
        return rv;   
    }
    
    
}
